/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.schedule;

import java.util.List;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.module.sys.log.bean.CoreLoginLogBean;
import net.sinodawn.module.sys.log.service.CoreLoginLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Repository;

@Repository
public class AuthenticationExpiredSchedule {
    @Autowired
    private CoreLoginLogService loginLogService;

    @Scheduled(fixedDelay=30000L)
    public void schedule() {
        SinoConcurrentLocker.isolatedRun("SECDURITY_ONLINE_TESTING_SCHEDULE", () -> {
            CoreLoginLogBean filter = BeanUtils.getPropertyListenerProxy(CoreLoginLogBean.class);
            filter.setStatus("1");
            filter.setLogoutTime(null);
            List<CoreLoginLogBean> loginLogList = this.loginLogService.selectList(filter, new Order[0]);
            if (!loginLogList.isEmpty()) {
                for (CoreLoginLogBean loginLog : loginLogList) {
                    Authentication authentication = AuthenticationHelper.getCacheAuthentication(loginLog.getToken());
                    if (authentication != null) continue;
                    this.loginLogService.assignLogout(loginLog.getToken(), I18nHelper.getMessage("SINO.SECURITY.LOGIN.TIMEOUT", new String[0]));
                }
            }
        });
    }
}

