/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.security.AccountCategory;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.security.exception.AccountOfflineException;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;

public class RefreshFilterSecurityInterceptor
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.isHomepageRequest(httpServletRequest) && LocalContextHelper.isUserLogin()) {
            ((HttpServletResponse)response).sendRedirect(ServletUtils.getContextPath() + "/module/index/workspaces");
        } else {
            if (!LocalContextHelper.isUserLogin()) {
                String rememberMeCookieToken = AuthenticationHelper.getLoginUserToken();
                if (StringUtils.isEmpty(rememberMeCookieToken)) {
                    rememberMeCookieToken = httpServletRequest.getHeader("sino-remember-me-cookie");
                }
                if (!StringUtils.isEmpty(rememberMeCookieToken)) {
                    String category = AuthenticationHelper.getOfflineCategory(rememberMeCookieToken);
                    if (AccountCategory.OFFLINE_PRELOGIN.name().equals(category)) {
                        throw new AccountOfflineException("SINO.SECURITY.LOGIN.OFFLINE_PRELOGIN");
                    }
                    if (AccountCategory.OFFLINE.name().equals(category)) {
                        throw new AccountOfflineException("SINO.SECURITY.LOGIN.OFFLINE");
                    }
                }
            }
            chain.doFilter(request, response);
        }
    }

    private boolean isHomepageRequest(HttpServletRequest request) {
        String requestUri = ServletUtils.getRequestUri(request);
        return "/".equals(requestUri);
    }
}

