/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.captcha.impl;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sinodawn.framework.exception.NetworkException;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.security.captcha.SecurityCaptchaService;
import net.sinodawn.framework.utils.EncryptUtils;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.config.helper.SystemConfigHelper;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.stereotype.Repository;

@Repository
public class SecurityCaptchaServiceImpl
implements SecurityCaptchaService {
    public static final String CAPTCHA_COOKIE_NAME = "captcha";
    public static final String CAPTCHA_PARAM_NAME = "captcha";
    public static final String CAPTCHA_RELOGIN_HEADER = "relogin";
    public static final String CAPTCHA_REQUIRE = "captchaRequire";
    private Producer producer;

    @Override
    public final void captchaImage() {
        HttpServletResponse response = ServletUtils.getCurrentResponse();
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            String captchaCode = this.outputAndReturnCode(SecurityCaptchaServiceImpl.getServletOutputStreamProxy(os));
            ServletUtils.addCookie(ServletUtils.getCurrentRequest(), response, "captcha", EncryptUtils.bcryptEncode(captchaCode), -1);
        }
        catch (IOException var14) {
            throw new NetworkException(var14);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (Exception exception) {}
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String outputAndReturnCode(ServletOutputStream os) {
        String captcha = this.getCaptchaProducer().createText().toUpperCase();
        BufferedImage challenge = this.getCaptchaProducer().createImage(captcha);
        try {
            ImageIO.write((RenderedImage)challenge, "jpeg", (OutputStream)os);
            return captcha;
        }
        catch (IOException var5) {
            throw new UnexpectedException(var5);
        }
    }

    @Override
    public final void checkCaptcha() {
        if ("1".equals(SystemConfigHelper.getLoginConfig().getCaptcha())) {
            HttpServletRequest request = ServletUtils.getCurrentRequest();
            if (request == null) {
                throw new AuthenticationServiceException("SINO.SECURITY.CAPTCHA.CAPTCHA_NOT_PRESENT");
            }
            if (!"0".equals(request.getParameter(CAPTCHA_REQUIRE)) && !"1".equals(request.getHeader(CAPTCHA_RELOGIN_HEADER))) {
                Cookie captchaCookie = ServletUtils.getCookie(request, "captcha");
                if (captchaCookie == null) {
                    throw new AuthenticationServiceException("SINO.SECURITY.CAPTCHA.COOKIE_NOT_PRESENT");
                }
                String captcha = request.getParameter("captcha");
                if (StringUtils.isBlank(captcha)) {
                    throw new AuthenticationServiceException("SINO.SECURITY.CAPTCHA.CAPTCHA_NOT_PRESENT");
                }
                if (!EncryptUtils.bcryptMatches(captcha.toUpperCase(), captchaCookie.getValue())) {
                    throw new AuthenticationServiceException("SINO.SECURITY.CAPTCHA.INCORRECT_CAPTCHA");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Producer getCaptchaProducer() {
        if (this.producer != null) return this.producer;
        Class<SecurityCaptchaServiceImpl> var1 = SecurityCaptchaServiceImpl.class;
        Class<SecurityCaptchaServiceImpl> clazz = SecurityCaptchaServiceImpl.class;
        synchronized (SecurityCaptchaServiceImpl.class) {
            if (this.producer != null) return this.producer;
            this.producer = new DefaultKaptcha();
            Properties properties = new Properties();
            properties.setProperty("kaptcha.border", "yes");
            properties.setProperty("kaptcha.border.color", "105,179,90");
            properties.setProperty("kaptcha.textproducer.font.color", "201,94,49");
            properties.setProperty("kaptcha.image.width", "100");
            properties.setProperty("kaptcha.image.height", "40");
            properties.setProperty("kaptcha.textproducer.font.size", "25");
            properties.setProperty("kaptcha.textproducer.char.length", "4");
            properties.setProperty("kaptcha.textproducer.char.space", "6");
            properties.setProperty("kaptcha.textproducer.font.names", "\u5b8b\u4f53,\u6977\u4f53,\u5fae\u8f6f\u96c5\u9ed1");
            properties.setProperty("kaptcha.noise.impl", "com.google.code.kaptcha.impl.NoNoise");
            properties.setProperty("kaptcha.background.impl", "com.google.code.kaptcha.impl.DefaultBackground");
            properties.setProperty("kaptcha.background.clear.from", "247,254,236");
            properties.setProperty("kaptcha.background.clear.to", "247,254,236");
            properties.setProperty("kaptcha.obscurificator.impl", "com.google.code.kaptcha.impl.ShadowGimpy");
            Config config = new Config(properties);
            ((DefaultKaptcha)this.producer).setConfig(config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.producer;
        }
    }

    private static final ServletOutputStream getServletOutputStreamProxy(ServletOutputStream target) {
        ServletOutputStreamMethodInterceptor interceptor = new ServletOutputStreamMethodInterceptor(target);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(ServletOutputStream.class);
        enhancer.setCallback((Callback)interceptor);
        return (ServletOutputStream)enhancer.create();
    }

    private static class ServletOutputStreamMethodInterceptor
    implements MethodInterceptor {
        private ServletOutputStream target;

        private ServletOutputStreamMethodInterceptor(ServletOutputStream target) {
            this.target = target;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return !"flush".equals(method.getName()) && !"close".equals(method.getName()) ? method.invoke((Object)this.target, args) : null;
        }

        ServletOutputStreamMethodInterceptor(ServletOutputStream x0, Object x1) {
            this(x0);
        }
    }
}

