/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.security.authentication;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.cache.redis.RedisHelper;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.security.provider.service.SecurityProviderService;
import net.sinodawn.framework.utils.EncryptUtils;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.log.service.CoreLoginLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationHelper {
    private static CacheManager cacheManager;
    private static RedisTemplate redisTemplate;

    @Autowired
    public void setCacheManager(CacheManager cacheManager) {
        AuthenticationHelper.cacheManager = cacheManager;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        AuthenticationHelper.redisTemplate = redisTemplate;
    }

    public static List<String> getLoginTokenList() {
        ArrayList<String> tokens = new ArrayList<String>();
        try {
            Optional.ofNullable(redisTemplate.keys((Object)"security#rememberme*")).ifPresent(tokens::addAll);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tokens;
    }

    public static void login(HttpServletRequest request, Authentication successfulAuthentication, String rememberMeToken) {
        Objects.requireNonNull(cacheManager.getCache("security#rememberme")).put((Object)rememberMeToken, (Object)successfulAuthentication);
        ApplicationContextHelper.getBean(CoreLoginLogService.class).insertLoginSuccessLog(rememberMeToken, successfulAuthentication.getName(), LocalContextHelper.getLoginOrgId());
    }

    public static void logout(String rememberMeToken, String remark) {
        Objects.requireNonNull(cacheManager.getCache("security#rememberme")).evict((Object)rememberMeToken);
        ApplicationContextHelper.getBean(CoreLoginLogService.class).assignLogout(rememberMeToken, remark);
    }

    public static Authentication getCacheAuthentication(String rememberMeToken) {
        return (Authentication)Objects.requireNonNull(cacheManager.getCache("security#rememberme")).get((Object)rememberMeToken, Authentication.class);
    }

    public static void updateCacheAuthentication(String rememberMeToken, Authentication authentication) {
        Objects.requireNonNull(cacheManager.getCache("security#rememberme")).put((Object)rememberMeToken, (Object)authentication);
    }

    public static void markOffline(String rememberMeToken, String category) {
        RedisHelper.put("MARK_OFFLINE", rememberMeToken, category, 300);
    }

    public static String getOfflineCategory(String rememberMeToken) {
        return (String)RedisHelper.get("MARK_OFFLINE", rememberMeToken);
    }

    public static String getLoginUserToken() {
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        if (request == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!"sino-remember-me-cookie".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return request.getHeader("sino-remember-me");
    }

    public static String getRawPassword(String password) {
        String publicKey;
        if (ServletUtils.getCurrentRequest() != null && !StringUtils.isBlank(publicKey = ServletUtils.getCurrentRequest().getHeader("SECURITY-RSA-KEY"))) {
            SecurityProviderService providerService = ApplicationContextHelper.getBean(SecurityProviderService.class);
            return EncryptUtils.RSADecrypt(password, providerService.getPrivateKey(publicKey));
        }
        return password;
    }
}

