/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.restful.resolver.wrapper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.restful.data.RestFieldValueTextContainer;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.resolver.AbstractJsonResolveArgumentHandler;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

public class ToRestJsonWrapperResolveArgumentHandler
extends AbstractJsonResolveArgumentHandler<RestJsonWrapperBean> {
    public ToRestJsonWrapperResolveArgumentHandler(MethodParameter parameter, NativeWebRequest webRequest) {
        super(parameter, webRequest);
    }

    @Override
    public boolean supports() {
        HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);
        return !"GET".equals(request.getMethod()) && StringUtils.contains(request.getContentType(), "application/json");
    }

    @Override
    public RestJsonWrapperBean resolveArgument() {
        String requestJson = this.getRequestJson();
        if (StringUtils.isEmpty(requestJson)) {
            return new RestJsonWrapperBean();
        }
        JSONObject jo = this.convertRequestJson(requestJson);
        String converterJson = jo.toJSONString();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String paramStr = jo.getString("p");
        if (!StringUtils.isEmpty(paramStr)) {
            JSONObject paramObject = JSONObject.parseObject((String)paramStr);
            paramObject.entrySet().stream().forEach(e -> {
                String var10000 = paramMap.put((String)e.getKey(), ConvertUtils.convert(e.getValue(), String.class));
            });
            String t = (String)paramMap.get("t");
            if (!StringUtils.isEmpty(t)) {
                this.setValueTextContainer(t);
            }
        }
        ArrayList<List<String>> bodyList = new ArrayList<List<String>>();
        ArrayList bodyServiceList = new ArrayList();
        int index = 0;
        JSONArray array;
        while ((array = jo.getJSONArray("b" + (Serializable)(index > 0 ? Integer.valueOf(index) : ""))) != null && !array.isEmpty()) {
            String serviceName = array.getString(0);
            JSONArray contentArray = array.getJSONArray(1);
            if (contentArray != null && !contentArray.isEmpty()) {
                List contentList = contentArray.stream().map(a -> ((JSONObject)a).toJSONString()).collect(Collectors.toList());
                bodyList.add(contentList);
                if (StringUtils.isEmpty(serviceName)) {
                    bodyServiceList.add(null);
                } else if (StringUtils.contains(serviceName, "_")) {
                    bodyServiceList.add((GenericService<?, ?>)ApplicationContextHelper.getServiceByTable(serviceName));
                } else {
                    bodyServiceList.add((GenericService)ApplicationContextHelper.getBean(serviceName));
                }
            }
            ++index;
        }
        return new RestJsonWrapperBean(converterJson, paramMap, bodyList, bodyServiceList);
    }

    private void setValueTextContainer(String tJson) {
        JSONObject tjo = JSONObject.parseObject((String)tJson);
        RestFieldValueTextContainer valueTextContainer = RestFieldValueTextContainer.getInstance();
        tjo.forEach((k, v) -> {
            JSONObject vjo = (JSONObject)v;
            String type = vjo.getString("type");
            String items = vjo.getString("items");
            if (items == null) {
                valueTextContainer.addFieldData((String)k, type);
            } else {
                HashMap<String, String> valueTextMap = new HashMap<String, String>();
                JSONArray ija = JSONObject.parseArray((String)items);
                int j = ija.size();
                for (int i = 0; i < j; ++i) {
                    JSONObject ijo = (JSONObject)ija.get(i);
                    valueTextMap.put(ijo.getString("value"), ijo.getString("text"));
                }
                valueTextContainer.addFieldData((String)k, type, (Map<String, String>)valueTextMap);
            }
        });
        HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);
        request.setAttribute("SINO_RFVTC", (Object)valueTextContainer);
    }

    private JSONObject convertRequestJson(String requestJson) {
        JSONObject jo = JSONObject.parseObject((String)requestJson);
        String json = jo.getString("requestJson");
        return !StringUtils.isBlank(json) ? JSONObject.parseObject((String)json) : jo;
    }
}

