/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.restful.resolver.feign;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.exception.ResolverArgumentException;
import net.sinodawn.framework.restful.resolver.AbstractJsonResolveArgumentHandler;
import net.sinodawn.framework.restful.resolver.feign.annotation.FeignRequestParam;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.JsonUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

public class ToRestJsonFeignResolverArgumentHandler
extends AbstractJsonResolveArgumentHandler<Object> {
    private static final String FEIGN_PARAM_ATTRIBUTE = "SINO_FEIGN_PARAM";

    public ToRestJsonFeignResolverArgumentHandler(MethodParameter parameter, NativeWebRequest webRequest) {
        super(parameter, webRequest);
    }

    @Override
    public boolean supports() {
        HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);
        return !"GET".equals(request.getMethod()) && StringUtils.contains(request.getContentType(), "application/json");
    }

    @Override
    public Object resolveArgument() {
        Object value;
        String requestJson = this.getRequestBody();
        if (StringUtils.isEmpty(requestJson)) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject((String)requestJson);
        MethodParameter parameter = this.getParameter();
        FeignRequestParam parameterAnnotation = (FeignRequestParam)parameter.getParameterAnnotation(FeignRequestParam.class);
        String key = parameterAnnotation.value();
        if (!StringUtils.isEmpty(key)) {
            value = jsonObject.get((Object)key);
            if (value == null && parameterAnnotation.required()) {
                throw new ResolverArgumentException(String.format("required param %s is not present", key));
            }
        } else {
            key = parameter.getParameterName();
            value = jsonObject.get((Object)key);
        }
        Class parameterType = parameter.getParameterType();
        if (value != null) {
            if (ClassUtils.isPrimitiveType(parameterType)) {
                throw new ResolverArgumentException(String.format("param %s can not be primitiveType", key));
            }
            if (ClassUtils.isWrapperType(parameterType)) {
                return ConvertUtils.convert(value, parameterType);
            }
            return String.class.equals((Object)parameterType) ? value.toString() : this.parseObject(value, parameterType);
        }
        if (ClassUtils.isWrapperType(parameterType)) {
            if (parameterAnnotation.required()) {
                throw new ResolverArgumentException(String.format("required param %s is not present", key));
            }
            return null;
        }
        if (!parameterAnnotation.parseAllFields()) {
            if (parameterAnnotation.required()) {
                throw new ResolverArgumentException(String.format("required param %s is not present", key));
            }
            return null;
        }
        Object result = this.parseObject(jsonObject, parameterType);
        if (!parameterAnnotation.required()) {
            return result;
        }
        boolean haveValue = false;
        List<BeanPropertyDescriptor> bpdList = BeanPropertyHelper.getBeanPropertyDescriptorList(parameterType);
        for (BeanPropertyDescriptor bpd : bpdList) {
            if (bpd.isExt$BeanProperty() || bpd.getPropertyValue(result) == null) continue;
            haveValue = true;
        }
        if (!haveValue) {
            throw new ResolverArgumentException(String.format("required param %s is not present", key));
        }
        return result;
    }

    private String getRequestBody() {
        NativeWebRequest webRequest = this.getWebRequest();
        String jsonBody = (String)webRequest.getAttribute(FEIGN_PARAM_ATTRIBUTE, 0);
        if (jsonBody == null) {
            jsonBody = this.getRequestJson();
            webRequest.setAttribute(FEIGN_PARAM_ATTRIBUTE, (Object)jsonBody, 0);
        }
        return jsonBody;
    }

    private Object parseObject(Object value, Class<?> parameterType) {
        String json = value.toString();
        if (List.class.isAssignableFrom(parameterType)) {
            Class actualTypeArgument = (Class)((ParameterizedType)this.getParameter().getGenericParameterType()).getActualTypeArguments()[0];
            return BaseData.class.isAssignableFrom(actualTypeArgument) ? JsonUtils.parseList(json, actualTypeArgument) : JSON.parseArray((String)json, (Class)actualTypeArgument);
        }
        return BaseData.class.isAssignableFrom(parameterType) ? JsonUtils.parse(json, parameterType) : JSON.parseObject((String)json, parameterType);
    }
}

