/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.restful.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

public abstract class AbstractJsonResolveArgumentHandler<T> {
    private final MethodParameter parameter;
    private final NativeWebRequest webRequest;

    public AbstractJsonResolveArgumentHandler(MethodParameter parameter, NativeWebRequest webRequest) {
        this.parameter = Objects.requireNonNull(parameter);
        this.webRequest = Objects.requireNonNull(webRequest);
    }

    public MethodParameter getParameter() {
        return this.parameter;
    }

    public NativeWebRequest getWebRequest() {
        return this.webRequest;
    }

    protected String getRequestJson() {
        if (!this.supports()) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)this.getWebRequest().getNativeRequest(HttpServletRequest.class);
        try {
            String var4;
            try (ServletInputStream is = request.getInputStream();){
                var4 = StringUtils.read((InputStream)is);
            }
            return var4;
        }
        catch (IOException var16) {
            throw new UnexpectedException(var16);
        }
    }

    public abstract boolean supports();

    public abstract T resolveArgument();
}

