/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.restful.data.extractor;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.io.excel.support.PropertyContext;
import net.sinodawn.framework.io.excel.support.SheetContext;
import net.sinodawn.framework.io.excel.support.impl.DefaultPropertyContextImpl;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.extractor.ParamExtractor;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.DateTimeUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class DownloadParamExtractor
implements ParamExtractor<SheetContext> {
    private static final Logger logger = LogManager.getLogger(DownloadParamExtractor.class);
    private RestJsonWrapperBean jsonWrapper;

    public DownloadParamExtractor(RestJsonWrapperBean jsonWrapper) {
        this.jsonWrapper = jsonWrapper;
    }

    @Override
    public RestJsonWrapperBean getJsonWrapper() {
        return this.jsonWrapper;
    }

    @Override
    public SheetContext extract() {
        String topic = this.jsonWrapper.getParamValue("dt");
        List<TitleDef> titleDefList = this.jsonWrapper.parse(TitleDef.class);
        ArrayList<PropertyContext> propertyContextList = new ArrayList<PropertyContext>();
        titleDefList.forEach(t -> {
            MatchPattern pattern;
            String title = t.getName();
            String name = StringUtils.removeStart(t.getId(), "ext$.");
            MatchPattern matchPattern = MatchPattern.EQ;
            int pos = name.lastIndexOf("_");
            if (pos > 0 && (pattern = MatchPattern.getPatternIfPossible(name.substring(pos + 1))) != null) {
                matchPattern = pattern;
                name = name.substring(0, pos);
            }
            pattern = null;
            Function<Object, Object> function = !CollectionUtils.isEmpty(t.getOptions()) ? (MatchPattern.SB.equals((Object)matchPattern) ? v -> ConvertUtils.convert(t.getOptions().entrySet().stream().filter(e -> !StringUtils.isBlank((String)e.getKey())).filter(e -> StringUtils.startsWith(ConvertUtils.convert(v, String.class), (String)e.getKey())).map(e -> (String)e.getValue()).findFirst().orElse(null), String.class) : (MatchPattern.SC.equals((Object)matchPattern) ? v -> ConvertUtils.convert(t.getOptions().entrySet().stream().filter(e -> !StringUtils.isBlank((String)e.getKey())).filter(e -> StringUtils.contains((String)e.getKey(), ConvertUtils.convert(v, String.class))).map(e -> (String)e.getValue()).findFirst().orElse(null), String.class) : (MatchPattern.SE.equals((Object)matchPattern) ? v -> ConvertUtils.convert(t.getOptions().entrySet().stream().filter(e -> !StringUtils.isBlank((String)e.getKey())).filter(e -> StringUtils.endsWith((String)e.getKey(), ConvertUtils.convert(v, String.class))).map(e -> (String)e.getValue()).findFirst().orElse(null), String.class) : v -> {
                String value = ConvertUtils.convert(v, String.class);
                return !StringUtils.isBlank(value) && value.contains(",") ? StringUtils.join(Arrays.asList(value.split(",")).stream().map(e -> this.getOptionValue((TitleDef)t, e)).collect(Collectors.toList()), " ") : this.getOptionValue((TitleDef)t, v);
            }))) : ("number".equals(t.getType()) ? v -> ConvertUtils.convert(v, Double.class) : ("date".equals(t.getType()) ? v -> DateTimeUtils.formatLocalDate(ConvertUtils.convert(v, LocalDate.class)) : ("dateTime".equals(t.getType()) ? v -> DateTimeUtils.formatLocalDateTime(ConvertUtils.convert(v, LocalDateTime.class)) : v -> ConvertUtils.convert(v, String.class))));
            HorizontalAlignment alignment = this.getAlignment(t.getAlignment());
            PropertyContext propertyContext = DefaultPropertyContextImpl.of(title, name, function, alignment);
            if (CollectionUtils.isEmpty(t.getOptions())) {
                propertyContext.setNumeric("number".equals(t.getType()));
            }
            if (!StringUtils.isBlank(t.getStyleFormatter())) {
                String finalName = name;
                BiConsumer<Cell, Object> styleConsumer = (cell, item) -> {
                    String styleFormatter = StringUtils.replace(t.getStyleFormatter().replaceAll("(\\\\r|\\\\n)+", "").trim(), "function", "function get");
                    ScriptEngineManager manager = new ScriptEngineManager();
                    ScriptEngine engine = manager.getEngineByName("JavaScript");
                    try {
                        engine.eval("var field = '" + finalName + "';");
                        engine.eval(styleFormatter);
                        Invocable invocable = (Invocable)((Object)engine);
                        Object result = invocable.invokeFunction("get", item);
                        if (result instanceof ScriptObjectMirror) {
                            Set set = ((ScriptObjectMirror)result).entrySet();
                            Iterator iterator = set.iterator();
                            while (iterator.hasNext()) {
                                IndexedColors indexedColors;
                                Map.Entry stringObjectEntry;
                                Map.Entry entry = stringObjectEntry = (Map.Entry)iterator.next();
                                String key = (String)entry.getKey();
                                Object value = entry.getValue();
                                CellStyle cs = cell.getCellStyle();
                                if ("backgroundColor".equals(key)) {
                                    indexedColors = this.getIndexedColorsIfPresent(value.toString());
                                    if (indexedColors == null) continue;
                                    cs.setFillForegroundColor(indexedColors.getIndex());
                                    cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                    continue;
                                }
                                if (!"color".equals(key) || (indexedColors = this.getIndexedColorsIfPresent(value.toString())) == null) continue;
                                int index = cs.getFontIndexAsInt();
                                Font font = cell.getSheet().getWorkbook().getFontAt(index);
                                font.setColor(indexedColors.getIndex());
                            }
                        }
                    }
                    catch (Exception var19) {
                        logger.warn(var19.getMessage());
                    }
                };
                propertyContext.setStyleConsumer(styleConsumer);
            }
            propertyContextList.add(propertyContext);
        });
        ArrayList<Pair<String, Pair<Integer, Integer>>> subTopicList = new ArrayList<Pair<String, Pair<Integer, Integer>>>();
        block0: for (int i = 0; i < titleDefList.size(); ++i) {
            TitleDef def = titleDefList.get(i);
            if (StringUtils.isEmpty(def.getParentTitle()) || subTopicList.stream().anyMatch(t -> ((String)t.getFirst()).equals(def.getParentTitle()))) continue;
            for (int j = i; j < titleDefList.size(); ++j) {
                TitleDef subDef = titleDefList.get(j);
                if (j == titleDefList.size() - 1) {
                    if (!def.getParentTitle().equals(subDef.getParentTitle())) continue;
                    subTopicList.add(Pair.of(def.getParentTitle(), Pair.of(i + 1, j + 1)));
                    continue block0;
                }
                if (def.getParentTitle().equals(subDef.getParentTitle())) continue;
                subTopicList.add(Pair.of(def.getParentTitle(), Pair.of(i + 1, j)));
                continue block0;
            }
        }
        if (subTopicList.isEmpty()) {
            return new SheetContext(topic, topic, propertyContextList);
        }
        return new SheetContext(topic, topic, propertyContextList, subTopicList);
    }

    private HorizontalAlignment getAlignment(String alignment) {
        int var3 = -1;
        switch (alignment.hashCode()) {
            case -1364013995: {
                if (!alignment.equals("center")) break;
                var3 = 2;
                break;
            }
            case 3317767: {
                if (!alignment.equals("left")) break;
                var3 = 0;
                break;
            }
            case 108511772: {
                if (!alignment.equals("right")) break;
                var3 = 1;
            }
        }
        switch (var3) {
            case 0: {
                return HorizontalAlignment.LEFT;
            }
            case 1: {
                return HorizontalAlignment.RIGHT;
            }
            case 2: {
                return HorizontalAlignment.CENTER;
            }
        }
        return HorizontalAlignment.GENERAL;
    }

    private IndexedColors getIndexedColorsIfPresent(String color) {
        for (IndexedColors indexedColors : IndexedColors.values()) {
            if (!indexedColors.name().equalsIgnoreCase(color)) continue;
            return indexedColors;
        }
        return null;
    }

    private String getOptionValue(TitleDef t, Object value) {
        String optionKey = ConvertUtils.convert(value, String.class);
        if (StringUtils.isBlank(optionKey)) {
            return "";
        }
        String optionValue = t.getOptions().get(optionKey);
        return optionValue == null ? optionKey : optionValue;
    }

    public static class TitleDef {
        private String id;
        private String name;
        private String alignment;
        private String type;
        private String parentTitle;
        private String styleFormatter;
        private Map<String, String> options;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlignment() {
            return this.alignment;
        }

        public void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        public String getParentTitle() {
            return this.parentTitle;
        }

        public void setParentTitle(String parentTitle) {
            this.parentTitle = parentTitle;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public void setOptions(Map<String, String> options) {
            this.options = options;
        }

        public String getStyleFormatter() {
            return this.styleFormatter;
        }

        public void setStyleFormatter(String styleFormatter) {
            this.styleFormatter = styleFormatter;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

