/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.restful.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.PageRequest;
import net.sinodawn.framework.database.sql.SqlHelper;
import net.sinodawn.framework.exception.HackingDataException;
import net.sinodawn.framework.exception.InvalidDataException;
import net.sinodawn.framework.exception.OutOfRangeException;
import net.sinodawn.framework.json.deserializer.DefaultJsonDeserializer;
import net.sinodawn.framework.mybatis.mapper.FilterParamPattern;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.DateTimeUtils;
import net.sinodawn.framework.utils.JsonUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;

public class RestJsonWrapperBean {
    private static final String VOID_VALUE = "VOID";
    public static final RestJsonWrapperBean EMPTY = new RestJsonWrapperBean(JSON.toJSONString(new HashMap()));
    private final Map<String, String> paramMap;
    private final List<List<String>> bodyList;
    @JSONField(serialize=false)
    private final List<GenericService<?, ?>> bodyServiceList;
    private final List<String> authorityList = new ArrayList<String>();
    private Class<? extends MapperParameter> mapperParameterClass;
    private final Map<String, Object> extFilter = new HashMap<String, Object>();
    private final List<FilterParamPattern> extStdFilter = new ArrayList<FilterParamPattern>();
    private final String requestJson;
    private static ParserConfig parserConfig = new ParserConfig();

    public RestJsonWrapperBean() {
        this.paramMap = new HashMap<String, String>();
        this.bodyList = CollectionUtils.emptyList();
        this.bodyServiceList = CollectionUtils.emptyList();
        this.requestJson = "";
    }

    public RestJsonWrapperBean(String filterJson) {
        this.paramMap = new HashMap<String, String>();
        this.paramMap.put("f", filterJson);
        this.bodyList = CollectionUtils.emptyList();
        this.bodyServiceList = CollectionUtils.emptyList();
        this.requestJson = "";
    }

    public RestJsonWrapperBean(Map<String, String> paramMap, List<List<String>> bodyList, List<GenericService<?, ?>> bodyServiceList) {
        this.paramMap = Optional.ofNullable(paramMap).orElse(new HashMap());
        this.bodyList = Optional.ofNullable(bodyList).orElse(CollectionUtils.emptyList());
        this.bodyServiceList = Optional.ofNullable(bodyServiceList).orElse(CollectionUtils.emptyList());
        this.requestJson = "";
    }

    public RestJsonWrapperBean(String requestjson, Map<String, String> paramMap, List<List<String>> bodyList, List<GenericService<?, ?>> bodyServiceList) {
        this.paramMap = Optional.ofNullable(paramMap).orElse(new HashMap());
        this.bodyList = Optional.ofNullable(bodyList).orElse(CollectionUtils.emptyList());
        this.bodyServiceList = Optional.ofNullable(bodyServiceList).orElse(CollectionUtils.emptyList());
        this.requestJson = requestjson;
    }

    public Map<String, String> getParamMap() {
        return Collections.unmodifiableMap(this.paramMap);
    }

    public String getParamValue(String key) {
        return this.paramMap.get(key);
    }

    public void removeParam(String key) {
        this.paramMap.remove(key);
    }

    public void setParamValue(String key, String value) {
        this.paramMap.put(key, value);
    }

    public List<List<String>> getBodyList() {
        return this.bodyList;
    }

    public List<GenericService<?, ?>> getBodyServiceList() {
        return this.bodyServiceList;
    }

    public String getRequestJson() {
        return this.requestJson;
    }

    public String getFilterValue(String key) {
        String filterJson = this.getParamValue("f");
        if (!StringUtils.isEmpty(filterJson)) {
            Map optionsMap = (Map)JSONObject.parseObject((String)filterJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            return (String)optionsMap.get(key);
        }
        return null;
    }

    public <V> void setFilterValue(String key, V value) {
        String filterJson = this.getParamValue("f");
        if (StringUtils.isEmpty(filterJson)) {
            HashMap<String, V> map = new HashMap<String, V>();
            map.put(key, value);
            this.paramMap.put("f", JSONObject.toJSONString(map));
        } else {
            Map map = (Map)JSONObject.parseObject((String)filterJson, (TypeReference)new TypeReference<Map<String, V>>(){}, (Feature[])new Feature[0]);
            map.put(key, value);
            this.paramMap.put("f", JSONObject.toJSONString((Object)map));
        }
    }

    public void setAuthority(String authority) {
        this.setFilterValue("authority_" + authority, "1");
    }

    public void setQueries(String category) {
        this.setFilterValue("queries_" + category, "1");
    }

    public MapperParameter extractMapFilter() {
        return this.mapperParameterClass == null ? this.extractMapFilter(MapperParameter.class) : this.extractMapFilter(this.mapperParameterClass);
    }

    public <M extends MapperParameter> M extractMapFilter(Class<M> mapperParameterClass) {
        String optionsJson;
        String orderJson;
        MapperParameter parameter = (MapperParameter)ClassUtils.newInstance(mapperParameterClass);
        this.extractFilter(parameter, this.getParamValue("f"));
        this.extractFilter(parameter, this.getParamValue("qf"));
        if (!this.extStdFilter.isEmpty()) {
            FilterParamPattern[] paramPatterns = ArrayUtils.concat((FilterParamPattern[])parameter.get("filterParamPatterns"), this.extStdFilter.toArray(new FilterParamPattern[0]));
            parameter.put("filterParamPatterns", paramPatterns);
        }
        if (!StringUtils.isEmpty(orderJson = this.getParamValue("o"))) {
            JSONArray array = JSONObject.parseArray((String)orderJson);
            array.forEach(a -> ((JSONObject)a).forEach((key, value) -> {
                if (SqlHelper.isRiskySqlSegment(key)) {
                    throw new InvalidDataException("Order param contains risky words, the value is [" + key + "]");
                }
                if ("asc".equals(value) || "desc".equals(value)) {
                    parameter.setOrderParam(StringUtils.removeStartIgnoreCase(key, "ext$."), (String)value);
                }
            }));
        }
        if (!StringUtils.isEmpty(optionsJson = this.getParamValue("r"))) {
            Map optionsMap = (Map)JSONObject.parseObject((String)optionsJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            HashMap resolvedOptionsMap = new HashMap();
            optionsMap.forEach((k, v) -> {
                Map options = (Map)JSONObject.parseObject((String)v, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                resolvedOptionsMap.put(k, options);
            });
            parameter.put("optionsMap", resolvedOptionsMap);
        }
        parameter.putAll(this.getExtFilter());
        return (M)parameter;
    }

    public void setTotalFieldNames(String ... totalFieldNames) {
        this.paramMap.put("tf", String.join((CharSequence)",", Arrays.asList(totalFieldNames)));
    }

    @JSONField(serialize=false)
    public String[] getSumProperties() {
        String tf = this.paramMap.get("tf");
        return StringUtils.isBlank(tf) ? new String[]{} : StringUtils.split(tf, ",");
    }

    @JSONField(serialize=false)
    public String[] getCountProperties() {
        String cp = this.paramMap.get("cp");
        return StringUtils.isBlank(cp) ? new String[]{} : StringUtils.split(cp, ",");
    }

    public void removePageParams() {
        this.paramMap.put("n", "-1");
        this.paramMap.put("s", "-1");
    }

    public PageRequest extractPageRequest() {
        PageRequest pageRequest = new PageRequest();
        pageRequest.setPageNumber(NumberUtils.parseInt(this.getParamValue("n")));
        pageRequest.setPageSize(NumberUtils.parseInt(this.getParamValue("s")));
        pageRequest.setFilterJson(this.getParamValue("f"));
        pageRequest.setSumProperties(this.getSumProperties());
        pageRequest.setCountProperties(this.getCountProperties());
        return pageRequest;
    }

    public PageRowBounds extractPageRowBounds() {
        return new PageRowBounds(this.extractPageRequest());
    }

    public void setMapperParameterClass(Class<? extends MapperParameter> mapperParameterClass) {
        this.mapperParameterClass = mapperParameterClass;
    }

    public <T> T parseUnique(Class<T> beanClass) {
        int i;
        int size = this.getBodyList().size();
        ArrayList<T> itemList = new ArrayList<T>();
        for (i = 0; i < size; ++i) {
            GenericService<?, ?> service = this.getBodyServiceList().get(i);
            if (service == null || !service.getDao().getType().equals(beanClass)) continue;
            List<String> contentList = this.getBodyList().get(i);
            if (contentList.size() > 1) {
                throw new OutOfRangeException("core.rest.json.unable-parse-unique-bean");
            }
            itemList.add(RestJsonWrapperBean.parseObject(contentList.get(0), beanClass));
        }
        if (itemList.isEmpty()) {
            for (i = 0; i < size; ++i) {
                if (this.getBodyServiceList().get(i) != null) continue;
                List<String> contentList = this.getBodyList().get(i);
                if (contentList.size() > 1) {
                    throw new OutOfRangeException("core.rest.json.unable-parse-unique-bean");
                }
                itemList.add(RestJsonWrapperBean.parseObject(contentList.get(0), beanClass));
            }
        }
        if (itemList.size() != 1) {
            throw new OutOfRangeException("core.rest.json.unable-parse-unique-bean");
        }
        return (T)itemList.get(0);
    }

    public <T> List<T> parse(Class<T> beanClass) {
        int i;
        int size = this.getBodyServiceList().size();
        ArrayList itemList = new ArrayList();
        for (i = 0; i < size; ++i) {
            GenericService<?, ?> service = this.getBodyServiceList().get(i);
            if (service == null || !service.getDao().getType().equals(beanClass)) continue;
            this.getBodyList().get(i).forEach(b -> itemList.add(RestJsonWrapperBean.parseObject(b, beanClass)));
        }
        if (itemList.isEmpty()) {
            for (i = 0; i < size; ++i) {
                if (this.getBodyServiceList().get(i) != null) continue;
                this.getBodyList().get(i).forEach(b -> itemList.add(RestJsonWrapperBean.parseObject(b, beanClass)));
            }
        }
        return itemList;
    }

    public <T> List<T> parse(Class<T> beanClass, int index) {
        List<String> contentList = this.getBodyList().get(index);
        return contentList.stream().map(c -> RestJsonWrapperBean.parseObject(c, beanClass)).collect(Collectors.toList());
    }

    public <ID> List<ID> parseId(Class<ID> idType) {
        if (this.bodyList.size() > 1) {
            throw new OutOfRangeException("core.rest.json.unable-parse-id");
        }
        return this.bodyList.isEmpty() ? CollectionUtils.emptyList() : this.bodyList.get(0).stream().map(b -> {
            Map original = (Map)JSONObject.parseObject((String)String.valueOf(b), Map.class);
            return ConvertUtils.convert(original.get("id"), idType);
        }).distinct().collect(Collectors.toList());
    }

    public List<String> getAuthorityList() {
        return this.authorityList;
    }

    public void addAuthority(String authority) {
        this.authorityList.add("authority_" + authority);
    }

    public <V> void addExtFilter(String key, V value) {
        this.extFilter.put(key, value);
    }

    public Map<String, Object> getExtFilter() {
        return Collections.unmodifiableMap(this.extFilter);
    }

    public void addExtStdFilter(String key, Object value, MatchPattern matchPattern) {
        if (value == null) {
            this.extStdFilter.add(new FilterParamPattern(matchPattern.name(), key, value));
        } else if (List.class.isAssignableFrom(value.getClass())) {
            IdentityHashMap<String, Object> paramMap = new IdentityHashMap<String, Object>();
            for (Object v : (List)value) {
                paramMap.put(ObjectUtils.clone(key), v);
            }
            this.extStdFilter.add(new FilterParamPattern(matchPattern.name(), paramMap));
        } else if (value.getClass().isArray()) {
            IdentityHashMap<String, Object> paramMap = new IdentityHashMap<String, Object>();
            for (Object v : (Object[])value) {
                paramMap.put(ObjectUtils.clone(key), v);
            }
            this.extStdFilter.add(new FilterParamPattern(matchPattern.name(), paramMap));
        } else {
            this.extStdFilter.add(new FilterParamPattern(matchPattern.name(), key, value));
        }
    }

    private static <T> T parseObject(String json, Class<T> clazz) {
        T proxy = BeanUtils.getPropertyListenerProxy(clazz);
        JsonUtils.parse(json, proxy);
        return proxy;
    }

    private <M extends MapperParameter> void extractFilter(M parameter, String filterJson) {
        if (!StringUtils.isEmpty(filterJson)) {
            Map map = (Map)JSONObject.parseObject((String)filterJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            map.putAll(this.getExtFilter());
            ArrayList filterDataList = new ArrayList();
            map.entrySet().forEach(e -> {
                String key = StringUtils.replace((String)e.getKey(), "ext$.", "");
                if (SqlHelper.isRiskySqlSegment(key)) {
                    throw new HackingDataException(key);
                }
                if ("target_filter".equals(key)) {
                    Map taMap = (Map)JSONObject.parseObject((String)((String)e.getValue()), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    TargetTableFilterData filterData = new TargetTableFilterData();
                    filterData.setType((String)taMap.get("type"));
                    filterData.setTargetTable((String)taMap.get("targetTable"));
                    filterData.setTargetMatchColumn(Objects.toString(taMap.get("targetMatchColumn"), "ID"));
                    filterData.setThisMatchColumn(Objects.toString(taMap.get("thisMatchColumn"), "ID"));
                    String filter = (String)taMap.get("filter");
                    if (!StringUtils.isEmpty(filter)) {
                        JSONArray array = JSONObject.parseArray((String)filter);
                        int j = array.size();
                        for (int i = 0; i < j; ++i) {
                            JSONObject jsonObject = (JSONObject)array.get(i);
                            filterData.addTargetFilter(jsonObject.getString("targetFilterColumn"), jsonObject.getString("targetFilterValue"));
                        }
                    }
                    if (SqlHelper.isRiskySqlSegment(filterData.getTargetTable())) {
                        throw new HackingDataException("targetTable");
                    }
                    if (SqlHelper.isRiskySqlSegment(filterData.getTargetMatchColumn())) {
                        throw new HackingDataException("targetMatchColumn");
                    }
                    if (SqlHelper.isRiskySqlSegment(filterData.getThisMatchColumn())) {
                        throw new HackingDataException("thisMatchColumn");
                    }
                    filterData.getTargetFilter().keySet().forEach(k -> {
                        if (SqlHelper.isRiskySqlSegment(k)) {
                            throw new HackingDataException("targetFilterColumn");
                        }
                    });
                    parameter.put("targetFilter", filterData);
                } else {
                    MatchPattern matchPattern = Arrays.stream(MatchPattern.values()).filter(p -> StringUtils.endsWithIgnoreCase(key, "_" + p.name())).findFirst().orElse(null);
                    if (matchPattern == null) {
                        parameter.put(key, e.getValue());
                    } else {
                        filterDataList.addAll(RestJsonWrapperBean.parseFilterData(key, e.getValue(), matchPattern));
                    }
                }
            });
            HashMap<Object, List> filterMap = new HashMap<Object, List>();
            for (FilterData filterData : filterDataList) {
                String key = filterData.getKey() + "_" + filterData.getMatchPattern() + (String)(StringUtils.isEmpty(filterData.getGroup()) ? "" : ":" + filterData.getGroup());
                Object list = filterMap.get(key);
                if (list == null) {
                    list = new ArrayList();
                    filterMap.put(key, (List)list);
                }
                ((List)list).add(filterData);
            }
            if (!filterMap.isEmpty()) {
                ArrayList filterParamList = new ArrayList();
                filterMap.forEach((e, k) -> {
                    IdentityHashMap<String, Object> paramMap = new IdentityHashMap<String, Object>();
                    k.forEach(v -> paramMap.put(ObjectUtils.clone(v.getKey()), v.getValue()));
                    filterParamList.add(new FilterParamPattern(((FilterData)k.get(0)).getMatchPattern(), paramMap));
                });
                FilterParamPattern[] paramPatterns = ArrayUtils.concat((FilterParamPattern[])parameter.get("filterParamPatterns"), filterParamList.toArray(new FilterParamPattern[0]));
                parameter.put((String)"filterParamPatterns", (FilterParamPattern[])paramPatterns);
            }
        }
    }

    private static List<FilterData> parseFilterData(String originalName, Object originalValue, MatchPattern matchPattern) {
        if (VOID_VALUE.equals(originalValue)) {
            originalValue = null;
        }
        ArrayList<FilterData> filterDataList = new ArrayList<FilterData>();
        String name = StringUtils.removeEndIgnoreCase(originalName.toUpperCase(), "_" + matchPattern.name());
        String filterSeparator = ApplicationContextHelper.getEnvironment().getProperty("sino.search.multi-value-matching-seperator");
        String string = filterSeparator = StringUtils.isBlank(filterSeparator) ? "," : filterSeparator;
        if (MatchPattern.DEQ.equals((Object)matchPattern)) {
            LocalDate date = (LocalDate)matchPattern.parse(originalValue);
            if (date == null) {
                filterDataList.add(new FilterData(name, null, matchPattern.name()));
            } else {
                filterDataList.add(new FilterData(name, DateTimeUtils.formatLocalDate(date), matchPattern.name()));
            }
        } else if (MatchPattern.TEQ.equals((Object)matchPattern)) {
            LocalDateTime date = (LocalDateTime)matchPattern.parse(originalValue);
            if (date == null) {
                filterDataList.add(new FilterData(name, null, matchPattern.name()));
            } else {
                filterDataList.add(new FilterData(name, DateTimeUtils.formatLocalDateTime(date, "yyyy-MM-dd HH:mm"), matchPattern.name()));
            }
        } else {
            Object group = null;
            if (MatchPattern.DR.equals((Object)matchPattern)) {
                String[] strArray;
                if (originalValue != null) {
                    group = ((String)originalValue).substring(1, ((String)originalValue).length() - 1);
                }
                if ((strArray = StringUtils.split(group, ",")).length != 2) {
                    throw new OutOfRangeException("Range filter pattern must contains two values\uff08can be empty\uff09.");
                }
                for (int i = 0; i < 2; ++i) {
                    String value = strArray[i];
                    if (StringUtils.isEmpty(value)) continue;
                    LocalDate parsedValue = (LocalDate)matchPattern.parse(value);
                    if (i == 0) {
                        if (StringUtils.startsWith((String)originalValue, "(")) {
                            filterDataList.add(new FilterData(name, parsedValue, MatchPattern.DG.name()));
                            continue;
                        }
                        filterDataList.add(new FilterData(name, parsedValue, MatchPattern.DGOE.name()));
                        continue;
                    }
                    if (StringUtils.endsWith((String)originalValue, ")")) {
                        filterDataList.add(new FilterData(name, parsedValue, MatchPattern.DL.name()));
                        continue;
                    }
                    filterDataList.add(new FilterData(name, parsedValue.plusDays(1L), MatchPattern.DLOE.name()));
                }
            } else if (MatchPattern.TR.equals((Object)matchPattern)) {
                group = ((String)originalValue).substring(1, ((String)originalValue).length() - 1);
                String[] strArray = StringUtils.split((String)group, ",");
                if (strArray.length != 2) {
                    throw new OutOfRangeException("Range filter pattern must contains two values\uff08can be empty\uff09.");
                }
                for (int i = 0; i < 2; ++i) {
                    String value = strArray[i];
                    if (StringUtils.isEmpty(value)) continue;
                    LocalDate parsedValue = (LocalDate)matchPattern.parse(value);
                    if (i == 0) {
                        if (StringUtils.startsWith((String)originalValue, "(")) {
                            filterDataList.add(new FilterData(name, parsedValue, MatchPattern.TG.name()));
                            continue;
                        }
                        filterDataList.add(new FilterData(name, parsedValue, MatchPattern.TGOE.name()));
                        continue;
                    }
                    if (StringUtils.endsWith((String)originalValue, ")")) {
                        filterDataList.add(new FilterData(name, parsedValue, MatchPattern.TL.name()));
                        continue;
                    }
                    filterDataList.add(new FilterData(name, parsedValue.plusDays(1L), MatchPattern.TLOE.name()));
                }
            } else if (MatchPattern.NR.equals((Object)matchPattern)) {
                group = ((String)originalValue).substring(1, ((String)originalValue).length() - 1);
                String[] strArray = StringUtils.split((String)group, ",");
                if (strArray.length != 2) {
                    throw new OutOfRangeException("Range filter pattern must contains two values\uff08can be empty\uff09.");
                }
                for (int i = 0; i < 2; ++i) {
                    String value = strArray[i];
                    if (StringUtils.isEmpty(value)) continue;
                    LocalDate parsedValue = (LocalDate)matchPattern.parse(value);
                    if (i == 0) {
                        if (StringUtils.startsWith((String)originalValue, "(")) {
                            filterDataList.add(new FilterData(name, parsedValue, MatchPattern.NG.name()));
                            continue;
                        }
                        filterDataList.add(new FilterData(name, parsedValue, MatchPattern.NGOE.name()));
                        continue;
                    }
                    if (StringUtils.endsWith((String)originalValue, ")")) {
                        filterDataList.add(new FilterData(name, parsedValue, MatchPattern.NL.name()));
                        continue;
                    }
                    filterDataList.add(new FilterData(name, parsedValue, MatchPattern.NLOE.name()));
                }
            } else if (MatchPattern.MULTIPLE.equals((Object)matchPattern)) {
                String[] strArray;
                group = "" + System.nanoTime();
                String[] values = strArray = StringUtils.split(name, ",");
                int var18 = strArray.length;
                for (int var21 = 0; var21 < var18; ++var21) {
                    String str = values[var21];
                    filterDataList.add(new FilterData(str, originalValue, MatchPattern.OR.name(), (String)group));
                }
            } else if (!(MatchPattern.NOR.equals((Object)matchPattern) || MatchPattern.DOR.equals((Object)matchPattern) || MatchPattern.TOR.equals((Object)matchPattern) || MatchPattern.OR.equals((Object)matchPattern))) {
                if (!(MatchPattern.SB.equals((Object)matchPattern) || MatchPattern.SC.equals((Object)matchPattern) || MatchPattern.SE.equals((Object)matchPattern) || MatchPattern.SEQ.equals((Object)matchPattern) || MatchPattern.CISB.equals((Object)matchPattern) || MatchPattern.CISC.equals((Object)matchPattern) || MatchPattern.CISE.equals((Object)matchPattern) || MatchPattern.CISEQ.equals((Object)matchPattern))) {
                    if (MatchPattern.CBM.equals((Object)matchPattern)) {
                        group = (String)matchPattern.parse(originalValue);
                        if (!StringUtils.isBlank((String)group)) {
                            String[] values;
                            group = "" + System.nanoTime();
                            String[] var19 = values = StringUtils.split((String)group, ",");
                            int var21 = values.length;
                            for (int var22 = 0; var22 < var21; ++var22) {
                                String value = var19[var22];
                                filterDataList.add(new FilterData(name, value, MatchPattern.CBM.name(), (String)group));
                            }
                        }
                    } else if (MatchPattern.IN.equals((Object)matchPattern)) {
                        String[] strArray;
                        group = StringUtils.randomUUID(16);
                        String[] values = strArray = StringUtils.split(ConvertUtils.convert(originalValue, String.class), ",");
                        int var18 = strArray.length;
                        for (int var21 = 0; var21 < var18; ++var21) {
                            String str = values[var21];
                            filterDataList.add(new FilterData(name, matchPattern.parse(str), MatchPattern.OR.name(), (String)group));
                        }
                    } else if (originalValue != null && String.class.equals(originalValue.getClass()) && StringUtils.contains((String)originalValue, filterSeparator)) {
                        String[] strArray;
                        group = StringUtils.randomUUID(16);
                        String[] values = strArray = StringUtils.split((String)originalValue, filterSeparator);
                        int var18 = strArray.length;
                        for (int var21 = 0; var21 < var18; ++var21) {
                            String str = values[var21];
                            filterDataList.add(new FilterData(name, matchPattern.parse(str), matchPattern.name(), (String)group));
                        }
                    } else {
                        filterDataList.add(new FilterData(name, matchPattern.parse(originalValue), matchPattern.name()));
                    }
                } else {
                    group = (String)matchPattern.parse(originalValue);
                    if (group != null && StringUtils.startsWith(matchPattern.name(), "CI")) {
                        group = ((String)group).toUpperCase();
                    }
                    if (StringUtils.contains((String)group, filterSeparator)) {
                        String[] values;
                        group = StringUtils.randomUUID(16);
                        String[] var19 = values = StringUtils.split((String)group, filterSeparator);
                        int var21 = values.length;
                        for (int var22 = 0; var22 < var21; ++var22) {
                            String value = var19[var22];
                            filterDataList.add(new FilterData(name, value, "O" + matchPattern.name(), (String)group));
                        }
                    } else {
                        filterDataList.add(new FilterData(name, group, matchPattern.name()));
                    }
                }
            } else if (StringUtils.contains(name, "_")) {
                int index = name.lastIndexOf("_");
                filterDataList.add(new FilterData(name.substring(0, index), matchPattern.parse(originalValue), MatchPattern.OR.name(), name.substring(index + 1)));
            } else {
                filterDataList.add(new FilterData(name, matchPattern.parse(originalValue), MatchPattern.EQ.name()));
            }
        }
        return filterDataList;
    }

    static {
        parserConfig.putDeserializer(LocalDateTime.class, (ObjectDeserializer)DefaultJsonDeserializer.INSTANCE);
        parserConfig.putDeserializer(LocalDate.class, (ObjectDeserializer)DefaultJsonDeserializer.INSTANCE);
        parserConfig.putDeserializer(Time.class, (ObjectDeserializer)DefaultJsonDeserializer.INSTANCE);
        parserConfig.putDeserializer(Date.class, (ObjectDeserializer)DefaultJsonDeserializer.INSTANCE);
    }

    private static class FilterData {
        private final String key;
        private final Object value;
        private final String matchPattern;
        private String group;

        public FilterData(String key, Object value, String matchPattern, String group) {
            this.key = key;
            this.value = value;
            this.matchPattern = matchPattern;
            this.group = group;
        }

        public FilterData(String key, Object value, String matchPattern) {
            this.key = key;
            this.value = value;
            this.matchPattern = matchPattern;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String getMatchPattern() {
            return this.matchPattern;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public static class TargetTableFilterData {
        private String type;
        private String targetTable;
        private String targetMatchColumn;
        private String thisMatchColumn;
        private Map<String, Object> targetFilter = new HashMap<String, Object>();

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTargetTable() {
            return this.targetTable;
        }

        public void setTargetTable(String targetTable) {
            this.targetTable = targetTable;
        }

        public String getTargetMatchColumn() {
            return this.targetMatchColumn;
        }

        public void setTargetMatchColumn(String targetMatchColumn) {
            this.targetMatchColumn = targetMatchColumn;
        }

        public String getThisMatchColumn() {
            return this.thisMatchColumn;
        }

        public void setThisMatchColumn(String thisMatchColumn) {
            this.thisMatchColumn = thisMatchColumn;
        }

        public Map<String, Object> getTargetFilter() {
            return this.targetFilter;
        }

        public void addTargetFilter(String targetFilterColumn, String targetFilterValue) {
            this.targetFilter.put(targetFilterColumn, targetFilterValue);
        }
    }
}

