/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.restful.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.utils.ServletUtils;

public class RestFieldValueTextContainer {
    public static final String HTTP_SERVLET_REQUEST_ATTRIBUTE_KEY = "SINO_RFVTC";
    public List<FieldData> fieldDataList = new ArrayList<FieldData>();

    private RestFieldValueTextContainer() {
    }

    public static RestFieldValueTextContainer getInstance() {
        return new RestFieldValueTextContainer();
    }

    public static String getText(String field, String value) {
        HttpServletRequest request = ServletUtils.getCurrentRequest();
        if (request == null) {
            return value;
        }
        RestFieldValueTextContainer container = (RestFieldValueTextContainer)request.getAttribute(HTTP_SERVLET_REQUEST_ATTRIBUTE_KEY);
        if (container == null) {
            return value;
        }
        FieldData fieldData = container.fieldDataList.stream().filter(f -> f.getField().equalsIgnoreCase(field)).findFirst().orElse(null);
        return fieldData == null ? value : fieldData.getText(value);
    }

    public void addFieldData(String field, String type) {
        this.fieldDataList.add(new FieldData(field, type));
    }

    public void addFieldData(String field, String type, Map<String, String> valueTextMap) {
        this.fieldDataList.add(new FieldData(field, type, valueTextMap));
    }

    private static class FieldData {
        private final String field;
        private final FieldType type = Arrays.stream(FieldType.values()).filter(t -> t.name().equalsIgnoreCase(type)).findAny().get();
        private final Map<String, String> valueTextMap;

        public FieldData(String field, String type) {
            this(field, type, null);
        }

        public FieldData(String field, String type, Map<String, String> valueTextMap) {
            this.field = field;
            if (valueTextMap == null) {
                this.valueTextMap = new HashMap<String, String>();
                if (FieldType.CHECKBOX.equals((Object)this.type)) {
                    this.valueTextMap.put("0", "SINO.CHECKBOX.UNCHECKED");
                    this.valueTextMap.put("1", "SINO.CHECKBOX.CHECKED");
                }
            } else {
                this.valueTextMap = valueTextMap;
            }
        }

        public String getField() {
            return this.field;
        }

        public String getText(String value) {
            return this.valueTextMap.get(value);
        }
    }

    private static enum FieldType {
        SELECT,
        CHECKBOX;

    }
}

