/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.mybatis.page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.CollectionUtils;

public class MybatisPageHelper {
    private static final ThreadLocal<String> LOCAL_BIND_FLAG = new ThreadLocal();
    private static final ThreadLocal<PageRowBounds> LOCAL_PAGE_CONTAINER = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> LOCAL_COLUMN_TYPE_CONTAINER = new ThreadLocal();

    public static void bind(PageRowBounds rowBounds) {
        LOCAL_PAGE_CONTAINER.set(rowBounds);
    }

    public static PageRowBounds getBindPageRowBounds() {
        return LOCAL_PAGE_CONTAINER.get();
    }

    public static boolean isBind() {
        return LOCAL_BIND_FLAG.get() != null;
    }

    public static boolean isBindPageRowBounds() {
        return LOCAL_PAGE_CONTAINER.get() != null;
    }

    public static void setColumnTypeMap(Map<String, String> map) {
        HashMap container = new HashMap();
        map.forEach((k, v) -> container.put(k.toLowerCase(), MybatisPageHelper.getRevisedColumnType(v)));
        LOCAL_COLUMN_TYPE_CONTAINER.set(container);
    }

    public static void clearPage() {
        LOCAL_PAGE_CONTAINER.remove();
    }

    public static void clear() {
        LOCAL_BIND_FLAG.remove();
        LOCAL_PAGE_CONTAINER.remove();
        LOCAL_COLUMN_TYPE_CONTAINER.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Page<T> get(PageRowBounds rowBounds, Supplier<List<T>> supplier) {
        Pagination<T> var4;
        try {
            LOCAL_BIND_FLAG.set("1");
            if (rowBounds != null) {
                MybatisPageHelper.bind(rowBounds);
            }
            List<T> list = supplier.get();
            if (rowBounds != null) {
                Pagination<T> var42;
                Pagination<T> page = new Pagination<T>(rowBounds, list);
                page.setColumnTypeMap(LOCAL_COLUMN_TYPE_CONTAINER.get());
                Pagination<T> pagination = var42 = page;
                return pagination;
            }
            Pagination<T> page = new Pagination<T>(list);
            page.setColumnTypeMap(LOCAL_COLUMN_TYPE_CONTAINER.get());
            var4 = page;
        }
        finally {
            MybatisPageHelper.clear();
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Persistable<?>> Page<T> get(Class<T> type, PageRowBounds rowBounds, Supplier<List<Map<String, Object>>> supplier) {
        Pagination var6;
        try {
            List<Map<String, Object>> mapList;
            if (rowBounds != null) {
                MybatisPageHelper.bind(rowBounds);
            }
            if ((mapList = supplier.get()).isEmpty()) {
                if (rowBounds == null) {
                    Pagination page = new Pagination();
                    page.setColumnTypeMap(LOCAL_COLUMN_TYPE_CONTAINER.get());
                    Pagination pagination = page;
                    return pagination;
                }
                Pagination page = new Pagination(rowBounds, CollectionUtils.emptyList());
                page.setColumnTypeMap(LOCAL_COLUMN_TYPE_CONTAINER.get());
                Pagination pagination = page;
                return pagination;
            }
            List itemList = mapList.stream().map(m -> (Persistable)PersistableHelper.mapToPersistable(m, type)).collect(Collectors.toList());
            if (rowBounds == null) {
                Pagination var62;
                Pagination page = new Pagination(itemList);
                page.setColumnTypeMap(LOCAL_COLUMN_TYPE_CONTAINER.get());
                Pagination pagination = var62 = page;
                return pagination;
            }
            Pagination page = new Pagination(rowBounds, itemList);
            page.setColumnTypeMap(LOCAL_COLUMN_TYPE_CONTAINER.get());
            var6 = page;
        }
        finally {
            MybatisPageHelper.clear();
        }
        return var6;
    }

    private static String getRevisedColumnType(String columnType) {
        int var2 = -1;
        switch (columnType.hashCode()) {
            case 2374300: {
                if (!columnType.equals("Long")) break;
                var2 = 0;
                break;
            }
            case 798274969: {
                if (!columnType.equals("LocalDate")) break;
                var2 = 2;
                break;
            }
            case 1153828870: {
                if (!columnType.equals("LocalDateTime")) break;
                var2 = 3;
                break;
            }
            case 2052876273: {
                if (!columnType.equals("Double")) break;
                var2 = 1;
            }
        }
        switch (var2) {
            case 0: 
            case 1: {
                return "number";
            }
            case 2: {
                return "date";
            }
            case 3: {
                return "dateTime";
            }
        }
        return "string";
    }
}

