/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.mybatis.mapper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;

public enum MatchPattern {
    SB(String.class),
    SC(String.class),
    SE(String.class),
    SEQ(String.class),
    CISB(String.class),
    CISC(String.class),
    CISE(String.class),
    CISEQ(String.class),
    DG(LocalDate.class),
    DGOE(LocalDate.class),
    DL(LocalDate.class),
    DLOE(LocalDate.class),
    DEQ(LocalDate.class),
    DR(LocalDate.class),
    TG(LocalDateTime.class),
    TGOE(LocalDateTime.class),
    TL(LocalDateTime.class),
    TLOE(LocalDateTime.class),
    TEQ(LocalDateTime.class),
    TR(LocalDateTime.class),
    NG(Double.class),
    NGOE(Double.class),
    NL(Double.class),
    NLOE(Double.class),
    NEQ(Double.class),
    NR(Double.class),
    EQ(Void.class),
    DIFFER(Void.class),
    SPECIAL(String.class),
    MULTIPLE(String.class),
    NOR(Double.class),
    DOR(LocalDate.class),
    TOR(LocalDateTime.class),
    OR(String.class),
    CBM(String.class),
    IN(String.class);

    private Class<?> type;

    private MatchPattern(Class<?> type) {
        this.type = type;
    }

    public <T> T parse(Object value) {
        return (T)(Void.class.equals(this.type) ? value : ConvertUtils.convert(value, this.type));
    }

    public static MatchPattern getPatternIfPossible(String pattern) {
        return StringUtils.isEmpty(pattern) ? null : (MatchPattern)Arrays.stream(MatchPattern.values()).filter(p -> p.name().equals(pattern)).findAny().orElse(null);
    }
}

