/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.mybatis.dao;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.AuditTrailHelper;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.at.aspect.AuditTrailAspect;
import net.sinodawn.framework.audit.AuditDatabaseOperation;
import net.sinodawn.framework.audit.AuditLogHelper;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyEvent;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.beans.BeanPropertyListener;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.context.SinoAopContext;
import net.sinodawn.framework.context.SinoBeanContext;
import net.sinodawn.framework.data.ListChunkIterator;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pageable;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.context.instance.EntityColumnContextInstance;
import net.sinodawn.framework.database.context.instance.EntityContextInstance;
import net.sinodawn.framework.database.context.instance.EntityHelper;
import net.sinodawn.framework.database.core.DatabaseManager;
import net.sinodawn.framework.database.dialect.Dialect;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.database.sql.SqlType;
import net.sinodawn.framework.exception.checked.CheckedException;
import net.sinodawn.framework.exception.database.JdbcException;
import net.sinodawn.framework.exception.database.NotUniqueResultJdbcException;
import net.sinodawn.framework.mybatis.mapper.DaoMapper;
import net.sinodawn.framework.mybatis.page.MybatisPageHelper;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestFieldValueTextContainer;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.base.dao.GenericDao;
import net.sinodawn.framework.support.domain.Orderable;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Repository;

@Repository
public abstract class MybatisDaoSupport<T extends Persistable<ID>, ID extends Serializable>
implements GenericDao<T, ID> {
    @Autowired
    private Dialect dialect;
    @Autowired
    private DaoMapper daoMapper;
    @Autowired
    private SqlSessionTemplate mybatisTemplate;
    private final Class<T> type = ResolvableType.forClass(this.getClass()).as(GenericDao.class).getGeneric(new int[]{0}).resolve();

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public EntityContext getEntityContext() {
        return DatabaseManager.getEntityContext(this.type);
    }

    @Override
    public void insert(T item) {
        if (null != item) {
            AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
            this.preInsert(Collections.singletonList(item));
            EntityContextInstance contextInstance = EntityContextInstance.insertable(item, new String[0]);
            this.daoMapper.insert(contextInstance);
            if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.INSERT) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                String table = this.getTable();
                List<EntityColumnContextInstance> columnContextInstanceList = contextInstance.getColumnContextInstanceList();
                Serializable id = (Serializable)item.getId();
                ArrayList<CoreAuditTrailRecordLineBean> recordLineList = new ArrayList<CoreAuditTrailRecordLineBean>();
                for (EntityColumnContextInstance columnContextInstance : columnContextInstanceList) {
                    if (!AuditTrailHelper.auditTrailableColumn(table, columnContextInstance.getColumnContext().getColumnName())) continue;
                    CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                    line.setRecordType(SqlType.INSERT.name());
                    line.setTargetId(table + "$" + id);
                    line.setTableName(table);
                    line.setColumn(columnContextInstance.getColumnContext().getColumnName());
                    line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(columnContextInstance.getValue())));
                    recordLineList.add(line);
                }
                if (!recordLineList.isEmpty()) {
                    String targetId = AuditTrailAspect.getAncientTargetId(table, id);
                    AuditTrailAspect.addRecordLine(targetId, recordLineList);
                }
            }
            boolean cacheEvictOverrided = this.isCacheEvictOverrided();
            boolean auditable = AuditLogHelper.auditable(AuditDatabaseOperation.INSERT);
            if (cacheEvictOverrided || auditable) {
                Object selectedItem = this.selectById((Serializable)item.getId());
                if (auditable) {
                    AuditLogHelper.insertAuditLog(this.getTable(), null, selectedItem);
                }
                ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(null, selectedItem);
            }
        }
    }

    @Override
    public void insert(List<T> itemList) {
        if (null != itemList && !itemList.isEmpty()) {
            AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
            this.preInsert(itemList);
            EntityContext context = this.getEntityContext();
            int columnQty = context.getColumnContextList().size();
            int loopItemQty = Math.min(this.dialect.getMaxBatchInsertQty(), this.dialect.getMaxParamQty() / columnQty);
            ListChunkIterator<T> chunkIterator = ListChunkIterator.of(itemList, loopItemQty);
            while (chunkIterator.hasNext()) {
                this.daoMapper.batchInsert(context, chunkIterator.nextChunk().stream().map(t -> EntityContextInstance.insertable((Persistable)t, new String[0])).collect(Collectors.toList()));
            }
            if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.INSERT) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                String table = this.getTable();
                HashMap map = new HashMap();
                for (Persistable item : itemList) {
                    Serializable lineId = (Serializable)item.getId();
                    ArrayList<CoreAuditTrailRecordLineBean> recordLineList = new ArrayList<CoreAuditTrailRecordLineBean>();
                    for (EntityColumnContext columnContext : context.getColumnContextList()) {
                        if (!AuditTrailHelper.auditTrailableColumn(table, columnContext.getColumnName())) continue;
                        CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                        line.setRecordType(SqlType.INSERT.name());
                        line.setTargetId(table + "$" + lineId);
                        line.setTableName(table);
                        line.setColumn(columnContext.getColumnName());
                        line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(columnContext.getValue(item))));
                        recordLineList.add(line);
                    }
                    if (recordLineList.isEmpty()) continue;
                    map.put(lineId, recordLineList);
                }
                if (!map.isEmpty()) {
                    Map<Serializable, String> targetMap = AuditTrailAspect.getAncientTargetMap(table, new ArrayList(map.keySet()));
                    targetMap.forEach((k, v) -> AuditTrailAspect.addRecordLine(v, (List)map.get(k)));
                }
            }
            boolean cacheEvictOverrided = this.isCacheEvictOverrided();
            boolean auditable = AuditLogHelper.auditable(AuditDatabaseOperation.INSERT);
            if (cacheEvictOverrided || auditable) {
                List idList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
                List selectedItemList = this.selectListByIds(idList, new Order[0]);
                if (AuditLogHelper.auditable(AuditDatabaseOperation.INSERT)) {
                    for (Persistable selectedItem : selectedItemList) {
                        AuditLogHelper.insertAuditLog(this.getTable(), null, selectedItem);
                    }
                }
                for (Persistable selectedItem : selectedItemList) {
                    ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(null, selectedItem);
                }
            }
        }
    }

    @Override
    public void delete(ID id) {
        if (id == null) {
            throw new JdbcException("SINO.EXCEPTION.DELETE_REQUIRE_ID");
        }
        T selectedItem = this.selectByIdIfPresent(id);
        if (selectedItem != null) {
            AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
            EntityContextInstance contextInstance = EntityContextInstance.instance(selectedItem, new String[0]);
            if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.DELETE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                String table = this.getTable();
                CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                line.setRecordType(SqlType.DELETE.name());
                line.setTargetId(table + "$" + id);
                line.setTableName(table);
                line.setColumn("ID");
                line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(id)));
                String targetId = AuditTrailAspect.getAncientTargetId(table, id);
                AuditTrailAspect.addRecordLine(targetId, line);
            }
            this.daoMapper.deleteById(contextInstance);
            if (AuditLogHelper.auditable(AuditDatabaseOperation.DELETE)) {
                AuditLogHelper.insertAuditLog(this.getTable(), selectedItem, null);
            }
            ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(selectedItem, null);
        }
    }

    @Override
    public void deleteByIdList(List<ID> idList) {
        if (idList != null && !idList.isEmpty()) {
            AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
            if (idList.stream().anyMatch(i -> i == null)) {
                throw new JdbcException("SINO.EXCEPTION.DELETE_REQUIRE_ID");
            }
            if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.DELETE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                String table = this.getTable();
                HashMap<Serializable, CoreAuditTrailRecordLineBean> map = new HashMap<Serializable, CoreAuditTrailRecordLineBean>();
                Iterator<ID> iterator = idList.iterator();
                while (iterator.hasNext()) {
                    Serializable value;
                    Serializable id = value = (Serializable)iterator.next();
                    CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                    line.setRecordType(SqlType.DELETE.name());
                    line.setTargetId(table + "$" + id);
                    line.setTableName(table);
                    line.setColumn("ID");
                    line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(id)));
                    map.put(id, line);
                }
                if (!map.isEmpty()) {
                    Map<Serializable, String> targetMap = AuditTrailAspect.getAncientTargetMap(table, new ArrayList(map.keySet()));
                    targetMap.forEach((k, v) -> AuditTrailAspect.addRecordLine(v, (CoreAuditTrailRecordLineBean)map.get(k)));
                }
            }
            List<Persistable> selectedItemList = this.selectListByIds(idList, new Order[0]);
            ListChunkIterator chunkIterator = ListChunkIterator.of(selectedItemList, this.dialect.getInClauseIdMaxQty());
            while (chunkIterator.hasNext()) {
                this.daoMapper.batchDeleteById(this.getEntityContext(), chunkIterator.nextChunk().stream().map(t -> EntityContextInstance.instance((Persistable)t, new String[0])).collect(Collectors.toList()));
            }
            if (AuditLogHelper.auditable(AuditDatabaseOperation.DELETE)) {
                Iterator iterator = selectedItemList.iterator();
                while (iterator.hasNext()) {
                    Persistable t2;
                    Persistable selectedItem = t2 = (Persistable)iterator.next();
                    AuditLogHelper.insertAuditLog(this.getTable(), selectedItem, (Persistable)null);
                }
            }
            selectedItemList.forEach(i -> ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(i, null));
        }
    }

    @Override
    public void deleteBy(List<T> itemList, String ... searchColNames) {
        if (itemList != null && !itemList.isEmpty()) {
            List idList;
            if (ArrayUtils.isEmpty(searchColNames) && itemList.stream().anyMatch(i -> BeanUtils.isEmpty(i))) {
                throw new JdbcException("SINO.EXCEPTION.DELETE_REQUIRE_NONE_EMPTY_BEAN");
            }
            List<Object> list = idList = ArrayUtils.isEmpty(searchColNames) ? itemList.stream().filter(i -> i.getId() != null).map(i -> (Serializable)i.getId()).collect(Collectors.toList()) : this.selectIdList(itemList, ArrayUtils.asList(searchColNames), new Order[0]);
            if (!idList.isEmpty()) {
                this.deleteByIdList(idList);
            }
        }
    }

    @Override
    public void update(T item, List<String> updateColNameList, String ... searchColNames) {
        ArrayList clone = updateColNameList == null ? new ArrayList() : new ArrayList<String>(updateColNameList);
        EntityContextInstance contextInstance = EntityContextInstance.updatable(item, new String[0]);
        if (!clone.isEmpty()) {
            contextInstance.getColumnContextInstanceList().forEach(c -> c.setActive(clone.stream().anyMatch(n -> n.equalsIgnoreCase(c.getColumnContext().getColumnName()))));
        }
        if (EntityHelper.isColumnUpdated(contextInstance)) {
            Object service;
            String table;
            ArrayList<T> oldItemList = new ArrayList<T>();
            ArrayList<String> updatedColumnNameList = new ArrayList<String>();
            if (ArrayUtils.isEmpty(searchColNames)) {
                AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
                Object oldItem = this.selectById((Serializable)item.getId());
                if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.UPDATE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                    table = this.getTable();
                    ArrayList<CoreAuditTrailRecordLineBean> recordLineList = new ArrayList<CoreAuditTrailRecordLineBean>();
                    String finalTable1 = table;
                    String finalTable2 = table;
                    contextInstance.getColumnContextInstanceList().stream().filter(c -> c.isActive() && AuditTrailHelper.auditTrailableColumn(finalTable1, c.getColumnContext().getColumnName())).forEach(c -> {
                        CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                        line.setRecordType(SqlType.UPDATE.name());
                        line.setTargetId(finalTable2 + "$" + item.getId());
                        line.setTableName(finalTable2);
                        line.setColumn(c.getColumnContext().getColumnName().toUpperCase());
                        line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(c.getColumnContext().getValue(oldItem))));
                        line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(c.getValue())));
                        recordLineList.add(line);
                    });
                    if (!recordLineList.isEmpty()) {
                        table = AuditTrailAspect.getAncientTargetId(table, (Serializable)item.getId());
                        AuditTrailAspect.addRecordLine(table, recordLineList);
                    }
                }
                oldItemList.add(oldItem);
                this.daoMapper.updateById(contextInstance);
                contextInstance.getColumnContextInstanceList().stream().filter(EntityColumnContextInstance::isActive).forEach(c -> updatedColumnNameList.add(c.getColumnContext().getColumnName()));
            } else {
                oldItemList.addAll(this.selectList(item, ArrayUtils.asList(searchColNames), CollectionUtils.emptyList(), new Order[0]));
                if (!oldItemList.isEmpty()) {
                    int chunkSize = this.dialect.getInClauseIdMaxQty();
                    ListChunkIterator chunkIterator = ListChunkIterator.of(oldItemList, chunkSize);
                    while (chunkIterator.hasNext()) {
                        AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
                        List chunkList = chunkIterator.nextChunk();
                        if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.UPDATE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                            table = this.getTable();
                            HashMap map = new HashMap();
                            for (Object o : chunkList) {
                                Persistable oldItem = (Persistable)o;
                                ArrayList recordLineList = new ArrayList();
                                String finalTable = table;
                                String finalTable3 = table;
                                contextInstance.getColumnContextInstanceList().stream().filter(c -> c.isActive() && AuditTrailHelper.auditTrailableColumn(finalTable3, c.getColumnContext().getColumnName())).forEach(c -> {
                                    Object oldValue = c.getColumnContext().getValue(oldItem);
                                    if (!ObjectUtils.equals(oldValue, c.getValue())) {
                                        CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                                        line.setRecordType(SqlType.UPDATE.name());
                                        line.setTargetId(finalTable + "$" + oldItem.getId());
                                        line.setTableName(finalTable);
                                        line.setColumn(c.getColumnContext().getColumnName().toUpperCase());
                                        line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(oldValue)));
                                        line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(c.getValue())));
                                        recordLineList.add(line);
                                    }
                                });
                                if (recordLineList.isEmpty()) continue;
                                map.put((Serializable)oldItem.getId(), recordLineList);
                            }
                            if (!map.isEmpty()) {
                                Map<Serializable, String> targetMap = AuditTrailAspect.getAncientTargetMap(table, new ArrayList(map.keySet()));
                                targetMap.forEach((k, v) -> AuditTrailAspect.addRecordLine(v, (List)map.get(k)));
                            }
                        }
                        this.daoMapper.updateByIds(contextInstance, chunkList.stream().map(Persistable::getId).collect(Collectors.toList()));
                    }
                    contextInstance.getColumnContextInstanceList().stream().filter(c -> c.isActive()).forEach(c -> updatedColumnNameList.add(c.getColumnContext().getColumnName()));
                }
            }
            List idList = oldItemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
            boolean cacheEvictOverrided = this.isCacheEvictOverrided();
            boolean auditable = AuditLogHelper.auditable(AuditDatabaseOperation.UPDATE);
            if (cacheEvictOverrided || auditable) {
                List newItemList = this.selectListByIds(idList, new Order[0]);
                this.auditUpdate(oldItemList, newItemList);
                for (Persistable newItem : newItemList) {
                    Persistable oldItem = oldItemList.stream().filter(i -> ((Serializable)i.getId()).equals(newItem.getId())).findAny().orElse(null);
                    ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(oldItem, newItem);
                }
            }
            if ((service = SinoBeanContext.getServiceByTable(this.getTable())) != null) {
                service.postUpdate(updatedColumnNameList, idList);
            }
        }
    }

    @Override
    public void updateByIds(T item, List<ID> idList, String ... updateColNames) {
        EntityContextInstance contextInstance = EntityContextInstance.updatable(item, new String[0]);
        if (updateColNames != null && updateColNames.length > 0) {
            List<String> finalOldItemList = ArrayUtils.asList(updateColNames);
            contextInstance.getColumnContextInstanceList().forEach(p -> p.setActive(CollectionUtils.containsIgnoreCase(finalOldItemList, p.getColumnContext().getColumnName())));
        }
        if (EntityHelper.isColumnUpdated(contextInstance)) {
            List<String> updatedColumnNameList;
            Persistable oldItem;
            List oldItemList = this.selectListByIds(idList, new Order[0]);
            int chunkSize = this.dialect.getInClauseIdMaxQty();
            ListChunkIterator chunkIterator = ListChunkIterator.of(oldItemList, chunkSize);
            while (chunkIterator.hasNext()) {
                AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
                List chunkList = chunkIterator.nextChunk();
                if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.UPDATE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                    String table = this.getTable();
                    HashMap map = new HashMap();
                    Iterator iterator = chunkList.iterator();
                    while (iterator.hasNext()) {
                        Persistable persistable;
                        oldItem = persistable = (Persistable)iterator.next();
                        ArrayList recordLineList = new ArrayList();
                        Persistable finalOldItem = oldItem;
                        contextInstance.getColumnContextInstanceList().stream().filter(c -> c.isActive() && AuditTrailHelper.auditTrailableColumn(table, c.getColumnContext().getColumnName())).forEach(c -> {
                            Object oldValue = c.getColumnContext().getValue(finalOldItem);
                            if (!ObjectUtils.equals(oldValue, c.getValue())) {
                                CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                                line.setRecordType(SqlType.UPDATE.name());
                                line.setTargetId(table + "$" + finalOldItem.getId());
                                line.setTableName(table);
                                line.setColumn(c.getColumnContext().getColumnName().toUpperCase());
                                line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(oldValue)));
                                line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(c.getValue())));
                                recordLineList.add(line);
                            }
                        });
                        if (recordLineList.isEmpty()) continue;
                        map.put((Serializable)oldItem.getId(), recordLineList);
                    }
                    if (!map.isEmpty()) {
                        Map<Serializable, String> map2 = AuditTrailAspect.getAncientTargetMap(table, new ArrayList(map.keySet()));
                        map2.forEach((k, v) -> AuditTrailAspect.addRecordLine(v, (List)map.get(k)));
                    }
                }
                this.daoMapper.updateByIds(contextInstance, chunkList.stream().map(Persistable::getId).collect(Collectors.toList()));
            }
            boolean cacheEvictOverrided = this.isCacheEvictOverrided();
            boolean auditable = AuditLogHelper.auditable(AuditDatabaseOperation.UPDATE);
            if (cacheEvictOverrided || auditable) {
                updatedColumnNameList = this.selectListByIds(idList, new Order[0]);
                this.auditUpdate(oldItemList, updatedColumnNameList);
                for (Object e : updatedColumnNameList) {
                    Persistable newItem = (Persistable)e;
                    oldItem = oldItemList.stream().filter(i -> ((Serializable)i.getId()).equals(newItem.getId())).findAny().orElse(null);
                    ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(oldItem, newItem);
                }
            }
            updatedColumnNameList = contextInstance.getColumnContextInstanceList().stream().filter(c -> c.isActive()).map(c -> c.getColumnContext().getColumnName()).collect(Collectors.toList());
            Object service = SinoBeanContext.getServiceByTable(this.getTable());
            if (service != null) {
                service.postUpdate(updatedColumnNameList, idList);
            }
        }
    }

    @Override
    public void update(List<T> itemList, String ... updateColNames) {
        if (itemList != null && !itemList.isEmpty()) {
            ArrayList<String> updateColNameList = new ArrayList<String>();
            if (ArrayUtils.isEmpty(updateColNames)) {
                Persistable item = (Persistable)itemList.get(0);
                EntityContextInstance contextInstance = EntityContextInstance.updatable(item, new String[0]);
                contextInstance.getColumnContextInstanceList().forEach(i -> {
                    if (i.isActive() && !EntityHelper.isIdInstance(i)) {
                        updateColNameList.add(i.getColumnContext().getColumnName());
                    }
                });
            } else {
                updateColNameList.addAll(Arrays.asList(updateColNames));
            }
            if (!updateColNameList.isEmpty()) {
                Object service;
                Persistable newItem;
                List idList = itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList());
                List oldItemList = this.selectListByIds(idList, new Order[0]);
                int updateColQty = updateColNameList.size();
                int chunkSize = this.dialect.getInClauseIdMaxQty();
                int maxParamQty = this.dialect.getMaxParamQty();
                if (maxParamQty < chunkSize * (updateColQty * 2 + 1)) {
                    chunkSize = maxParamQty / (updateColQty * 2 + 1);
                }
                ListChunkIterator<T> chunkIterator = ListChunkIterator.of(itemList, chunkSize);
                while (chunkIterator.hasNext()) {
                    AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
                    List<T> chunkItemList = chunkIterator.nextChunk();
                    if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.UPDATE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                        String table = this.getTable();
                        HashMap<Serializable, ArrayList<CoreAuditTrailRecordLineBean>> map = new HashMap<Serializable, ArrayList<CoreAuditTrailRecordLineBean>>();
                        Iterator<T> var14 = chunkItemList.iterator();
                        while (true) {
                            if (!var14.hasNext()) {
                                if (map.isEmpty()) break;
                                Map<Serializable, String> targetMap = AuditTrailAspect.getAncientTargetMap(table, new ArrayList(map.keySet()));
                                targetMap.forEach((k, v) -> AuditTrailAspect.addRecordLine(v, (List)map.get(k)));
                                break;
                            }
                            newItem = (Persistable)var14.next();
                            boolean deleteFile = false;
                            Persistable finalNewItem = newItem;
                            Persistable oldItem = oldItemList.stream().filter(i -> ((Serializable)i.getId()).equals(finalNewItem.getId())).findFirst().get();
                            ArrayList<CoreAuditTrailRecordLineBean> recordLineList = new ArrayList<CoreAuditTrailRecordLineBean>();
                            for (String updateColName : updateColNameList) {
                                if (!AuditTrailHelper.auditTrailableColumn(table, updateColName)) continue;
                                Object oldValue = null;
                                Object newValue = null;
                                if (ReflectionUtils.findField(this.getType(), updateColName) == null) {
                                    oldValue = oldItem.getExt$().get(updateColName);
                                    newValue = newItem.getExt$().get(updateColName);
                                } else {
                                    oldValue = ReflectionUtils.getFieldValue(oldItem, updateColName);
                                    newValue = ReflectionUtils.getFieldValue(newItem, updateColName);
                                }
                                if (ObjectUtils.equals(oldValue, newValue)) continue;
                                CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                                line.setTargetId(table + "$" + oldItem.getId());
                                line.setTableName(table);
                                if (AuditTrailType.DELETE.equals((Object)auditTrailEntryData.getEntry().value()) && "TARGETID".equalsIgnoreCase(updateColName) && "T_CORE_FILE".equalsIgnoreCase(table)) {
                                    deleteFile = true;
                                    line.setRecordType(SqlType.DELETE.name());
                                    CoreFileBean file = (CoreFileBean)oldItem;
                                    line.setColumn("NAME");
                                    line.setOldValue(file.getName());
                                } else {
                                    line.setRecordType(SqlType.UPDATE.name());
                                    line.setColumn(updateColName.toUpperCase());
                                    line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(oldValue)));
                                    line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(newValue)));
                                }
                                recordLineList.add(line);
                            }
                            if (recordLineList.isEmpty()) continue;
                            if (deleteFile) {
                                CoreFileBean file = (CoreFileBean)oldItem;
                                int index = file.getTargetId().indexOf("$");
                                String strTargetId = index > 0 && index < file.getTargetId().length() ? AuditTrailAspect.getAncientTargetId(file.getTargetId().substring(0, index), file.getTargetId().substring(index + 1)) : file.getTargetId();
                                AuditTrailAspect.addRecordLine(strTargetId, recordLineList);
                                continue;
                            }
                            map.put((Serializable)newItem.getId(), recordLineList);
                        }
                    }
                    this.daoMapper.batchUpdateByIds(this.getEntityContext(), chunkItemList.stream().map(x$0 -> EntityContextInstance.updatable((Persistable)x$0, new String[0])).collect(Collectors.toList()), updateColNameList);
                }
                boolean cacheEvictOverrided = this.isCacheEvictOverrided();
                boolean auditable = AuditLogHelper.auditable(AuditDatabaseOperation.UPDATE);
                if (cacheEvictOverrided || auditable) {
                    List newItemList = this.selectListByIds(idList, new Order[0]);
                    this.auditUpdate(oldItemList, newItemList);
                    Iterator iterator = newItemList.iterator();
                    while (iterator.hasNext()) {
                        Persistable t;
                        Persistable finalNewItem1 = newItem = (t = (Persistable)iterator.next());
                        newItem = oldItemList.stream().filter(i -> ((Serializable)i.getId()).equals(finalNewItem1.getId())).findAny().orElse(null);
                        ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(newItem, newItem);
                    }
                }
                if ((service = SinoBeanContext.getServiceByTable(this.getTable())) != null) {
                    service.postUpdate(updateColNameList, idList);
                }
            }
        }
    }

    @Override
    public List<T> updateIfChanged(List<T> rawOrProxyItemList) {
        if (rawOrProxyItemList != null && !rawOrProxyItemList.isEmpty()) {
            List selectedItemList = this.selectListByIds(rawOrProxyItemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList()), new Order[0]);
            ArrayList resultList = new ArrayList();
            HashMap map = new HashMap();
            boolean proxy = BeanPropertyListener.class.isAssignableFrom(((Persistable)rawOrProxyItemList.get(0)).getClass());
            Iterator<T> var6 = rawOrProxyItemList.iterator();
            while (true) {
                AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
                if (!var6.hasNext()) {
                    if (!map.isEmpty()) {
                        Map<Serializable, String> targetMap = AuditTrailAspect.getAncientTargetMap(this.getTable(), new ArrayList(map.keySet()));
                        targetMap.forEach((k, v) -> AuditTrailAspect.addRecordLine(v, (List)map.get(k)));
                    }
                    return resultList;
                }
                Persistable rawOrProxyItem = (Persistable)var6.next();
                Persistable oldItem = selectedItemList.stream().filter(i -> ((Serializable)i.getId()).equals(rawOrProxyItem.getId())).findFirst().orElseThrow(() -> new CheckedException("SINO.EXCEPTION.NO_VALUE_EXISTS"));
                Persistable proxyItem = BeanUtils.getPropertyListenerProxy(ObjectUtils.clone(oldItem));
                if (proxy) {
                    List<BeanPropertyEvent> eventList = ((BeanPropertyListener)((Object)rawOrProxyItem)).getChangedPropertyEventList();
                    if (eventList.isEmpty()) continue;
                    Persistable finalProxyItem = proxyItem;
                    eventList.forEach(e -> e.getPropertyDescriptor().passValue(rawOrProxyItem, finalProxyItem));
                    ((BeanPropertyListener)((Object)proxyItem)).getChangedPropertyEventList().removeIf(e -> !StringUtils.isEmpty(e.getName()) && eventList.stream().noneMatch(re -> e.getName().equalsIgnoreCase(re.getName())));
                } else {
                    Persistable finalProxyItem1 = proxyItem;
                    this.getEntityContext().getColumnContextList().forEach(c -> {
                        Object value;
                        if (!c.getPropertyDescriptor().isExt$BeanProperty() && (value = c.getPropertyDescriptor().getPropertyValue(rawOrProxyItem)) != null) {
                            c.getPropertyDescriptor().passValue(rawOrProxyItem, finalProxyItem1);
                        }
                    });
                }
                if (!EntityHelper.isItemUpdated(proxyItem)) continue;
                EntityContextInstance proxyContextInstance = EntityContextInstance.updatable(proxyItem, new String[0]);
                if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.UPDATE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
                    String table = this.getTable();
                    ArrayList recordLineList = new ArrayList();
                    Persistable finalOldItem = oldItem;
                    proxyContextInstance.getColumnContextInstanceList().stream().filter(c -> c.isActive() && AuditTrailHelper.auditTrailableColumn(table, c.getColumnContext().getColumnName())).forEach(c -> {
                        CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                        line.setRecordType(SqlType.UPDATE.name());
                        line.setTargetId(table + "$" + finalOldItem.getId());
                        line.setTableName(table);
                        line.setColumn(c.getColumnContext().getColumnName().toUpperCase());
                        line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(c.getColumnContext().getValue(finalOldItem))));
                        line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(c.getValue())));
                        recordLineList.add(line);
                    });
                    if (!recordLineList.isEmpty()) {
                        map.put((Serializable)oldItem.getId(), recordLineList);
                    }
                }
                this.daoMapper.updateById(proxyContextInstance);
                Object newItem = this.selectById((Serializable)oldItem.getId());
                this.auditUpdate(Arrays.asList(oldItem), Arrays.asList(newItem));
                ((GenericDao)SinoAopContext.currentProxy()).cacheEvict(oldItem, newItem);
                List<String> updatedColumnNameList = proxyContextInstance.getColumnContextInstanceList().stream().filter(c -> c.isActive()).map(c -> c.getColumnContext().getColumnName()).collect(Collectors.toList());
                Object service = SinoBeanContext.getServiceByTable(this.getTable());
                if (service == null) continue;
                service.postUpdate(updatedColumnNameList, Arrays.asList((Serializable)proxyItem.getId()));
            }
        }
        return CollectionUtils.emptyList();
    }

    @Override
    public void updateCreatedBy(List<T> itemList) {
        List createdByColumnList;
        if (!itemList.isEmpty() && !(createdByColumnList = this.getEntityContext().getColumnContextList().stream().filter(c -> EntityHelper.isCreatedByColumn(c.getColumnName())).collect(Collectors.toList())).isEmpty()) {
            List oldItemList = this.selectListByIds(itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList()), new Order[0]);
            List<EntityContextInstance> contextInstanceList = itemList.stream().map(i -> EntityContextInstance.updatable(i, new String[0])).collect(Collectors.toList());
            this.daoMapper.batchUpdateByIds(this.getEntityContext(), contextInstanceList, createdByColumnList.stream().map(EntityColumnContext::getColumnName).collect(Collectors.toList()));
            if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(this.getTable(), AuditDatabaseOperation.UPDATE)) {
                HashMap map = new HashMap();
                AuditTrailAspect.AuditTrailEntryData auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData();
                if (auditTrailEntryData != null) {
                    String table = this.getTable();
                    Iterator<T> iterator = itemList.iterator();
                    while (iterator.hasNext()) {
                        Persistable t;
                        Persistable item = t = (Persistable)iterator.next();
                        ArrayList<CoreAuditTrailRecordLineBean> recordLineList = new ArrayList<CoreAuditTrailRecordLineBean>();
                        Persistable oldItem = oldItemList.stream().filter(s -> ((Serializable)s.getId()).equals(item.getId())).findAny().get();
                        for (EntityColumnContext columnContext : createdByColumnList) {
                            CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                            line.setRecordType(SqlType.UPDATE.name());
                            line.setTargetId(table + "$" + oldItem.getId());
                            line.setTableName(table);
                            line.setColumn(columnContext.getColumnName().toUpperCase());
                            line.setOldValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(columnContext.getValue(oldItem))));
                            line.setNewValue(RestFieldValueTextContainer.getText(line.getColumn(), ObjectUtils.toString(columnContext.getValue(item))));
                            recordLineList.add(line);
                        }
                        if (recordLineList.isEmpty()) continue;
                        map.put((Serializable)oldItem.getId(), recordLineList);
                    }
                }
                if (!map.isEmpty()) {
                    Map<Serializable, String> targetMap = AuditTrailAspect.getAncientTargetMap(this.getTable(), new ArrayList(map.keySet()));
                    targetMap.forEach((k, v) -> AuditTrailAspect.addRecordLine(v, (List)map.get(k)));
                }
            }
            this.auditUpdate(oldItemList, itemList);
            Object service = SinoBeanContext.getServiceByTable(this.getTable());
            if (service != null) {
                service.postUpdate(createdByColumnList.stream().map(EntityColumnContext::getColumnName).collect(Collectors.toList()), itemList.stream().map(i -> (Serializable)i.getId()).collect(Collectors.toList()));
            }
        }
    }

    @Override
    public T selectByIdIfPresent(ID id) {
        List<Map<String, Object>> mapList = this.daoMapper.selectByIds(this.getEntityContext(), Arrays.asList(id), CollectionUtils.emptyList(), CollectionUtils.emptyList());
        return (T)(mapList.isEmpty() ? null : (Persistable)PersistableHelper.mapToPersistable(mapList.get(0), this.getType()));
    }

    @Override
    public T selectOneIfPresent(T item, String ... selectColNames) {
        List<Map<String, Object>> mapList = this.daoMapper.select(EntityContextInstance.instance(item, new String[0]), ArrayUtils.asList(selectColNames), CollectionUtils.emptyList());
        if (mapList.isEmpty()) {
            return null;
        }
        if (mapList.size() > 1) {
            throw new NotUniqueResultJdbcException();
        }
        return (T)((Persistable)PersistableHelper.mapToPersistable(mapList.get(0), this.getType()));
    }

    @Override
    public <V> V selectColumnById(ID id, String colName, Class<V> colType) {
        List<Map<String, Object>> mapList = this.daoMapper.selectByIds(this.getEntityContext(), Arrays.asList(id), ArrayUtils.asList(colName), CollectionUtils.emptyList());
        if (mapList.isEmpty()) {
            return null;
        }
        if (mapList.size() > 1) {
            throw new NotUniqueResultJdbcException();
        }
        return ConvertUtils.convert(CollectionUtils.getFirstValue(mapList.get(0)), colType);
    }

    @Override
    public <V> List<V> selectColumnList(T item, List<String> searchColNames, String colName, Class<V> colType, Order ... orders) {
        EntityContextInstance contextInstance = EntityContextInstance.instance(item, new String[0]);
        if (searchColNames != null && !searchColNames.isEmpty()) {
            contextInstance.getColumnContextInstanceList().forEach(c -> c.setActive(CollectionUtils.containsIgnoreCase(searchColNames, c.getColumnContext().getColumnName())));
        }
        List<Order> orderList = orders == null ? CollectionUtils.emptyList() : Arrays.asList(orders);
        List<Map<String, Object>> mapList = this.daoMapper.select(contextInstance, ArrayUtils.asList(colName), orderList);
        return mapList.parallelStream().map(m -> ConvertUtils.convert(CollectionUtils.getFirstValue(m), colType)).collect(Collectors.toList());
    }

    @Override
    public List<T> selectAll(List<Order> orderList, String ... selectColNames) {
        List<Map<String, Object>> mapList = this.daoMapper.select(EntityContextInstance.instance((Persistable)ClassUtils.newInstance(this.getType()), new String[0]), ArrayUtils.asList(selectColNames), orderList);
        return mapList.parallelStream().map(m -> (Persistable)PersistableHelper.mapToPersistable(m, this.getType())).collect(Collectors.toList());
    }

    @Override
    public List<T> selectListByIds(List<ID> idList, List<String> selectColNameList, Order ... orders) {
        List<Map<String, Object>> mapList = this.selectMapListByIdList(idList, selectColNameList, orders);
        return mapList.parallelStream().map(m -> (Persistable)PersistableHelper.mapToPersistable(m, this.getType())).collect(Collectors.toList());
    }

    @Override
    public <V> List<V> selectColumnsByIds(List<ID> idList, String colName, Class<V> colType, Order ... orders) {
        List<Map<String, Object>> mapList = this.selectMapListByIdList(idList, Collections.singletonList(colName), orders);
        return mapList.parallelStream().map(m -> CollectionUtils.getValueIgnorecase(m, colName)).map(v -> ConvertUtils.convert(v, colType)).collect(Collectors.toList());
    }

    @Override
    public List<T> selectList(T item, List<String> searchColNames, List<String> selectColNameList, Order ... orders) {
        EntityContextInstance contextInstance = EntityContextInstance.instance(item, new String[0]);
        if (searchColNames != null && !searchColNames.isEmpty()) {
            contextInstance.getColumnContextInstanceList().forEach(c -> c.setActive(CollectionUtils.containsIgnoreCase(searchColNames, c.getColumnContext().getColumnName())));
        }
        if (selectColNameList == null) {
            selectColNameList = CollectionUtils.emptyList();
        }
        List<Map<String, Object>> mapList = this.daoMapper.select(contextInstance, selectColNameList, ArrayUtils.asList(orders));
        return mapList.parallelStream().map(m -> (Persistable)PersistableHelper.mapToPersistable(m, this.getType())).collect(Collectors.toList());
    }

    @Override
    public List<T> selectList(List<T> itemList, List<String> searchColNameList, List<String> selectColNameList, Order ... orders) {
        List<Map<String, Object>> mapList = this.selectMapList(itemList, searchColNameList, selectColNameList, orders);
        return mapList.parallelStream().map(m -> (Persistable)PersistableHelper.mapToPersistable(m, this.getType())).collect(Collectors.toList());
    }

    @Override
    public <V> List<V> selectList(List<T> itemList, List<String> searchColNameList, String colName, Class<V> colType, Order ... orders) {
        ArrayList<String> selectColNameList = new ArrayList<String>();
        selectColNameList.add(colName);
        List<Map<String, Object>> mapList = this.selectMapList(itemList, searchColNameList, selectColNameList, orders);
        return mapList.parallelStream().map(m -> ConvertUtils.convert(CollectionUtils.getValueIgnorecase(m, colName), colType)).collect(Collectors.toList());
    }

    @Override
    public T selectFirstIfPresent(T item, List<String> searchColNameList, List<String> selectColNameList, Order ... orders) {
        Map<String, Object> map;
        EntityContextInstance contextInstance = EntityContextInstance.instance(item, new String[0]);
        if (searchColNameList != null && !searchColNameList.isEmpty()) {
            contextInstance.getColumnContextInstanceList().forEach(c -> c.setActive(CollectionUtils.containsIgnoreCase(searchColNameList, c.getColumnContext().getColumnName())));
        }
        return (T)((map = this.daoMapper.selectFirst(contextInstance, selectColNameList, ArrayUtils.asList(orders))) == null ? null : (Persistable)PersistableHelper.mapToPersistable(map, this.getType()));
    }

    @Override
    public List<T> selectUnionList(T item, List<String> searchColNameList, List<String> selectColNameList, Order ... orders) {
        EntityContextInstance contextInstance = EntityContextInstance.instance(item, new String[0]);
        if (searchColNameList != null && !searchColNameList.isEmpty()) {
            contextInstance.getColumnContextInstanceList().forEach(c -> c.setActive(CollectionUtils.containsIgnoreCase(searchColNameList, c.getColumnContext().getColumnName())));
        }
        List<Map<String, Object>> mapList = this.daoMapper.selectUnion(contextInstance, selectColNameList, ArrayUtils.asList(orders));
        return mapList.parallelStream().map(m -> (Persistable)PersistableHelper.mapToPersistable(m, this.getType())).collect(Collectors.toList());
    }

    @Override
    public int countBy(T item, String ... searchColNames) {
        EntityContextInstance contextInstance = EntityContextInstance.instance(item, new String[0]);
        if (!ArrayUtils.isEmpty(searchColNames)) {
            contextInstance.getColumnContextInstanceList().forEach(c -> c.setActive(ArrayUtils.containsIgnoreCase(searchColNames, c.getColumnContext().getColumnName())));
        }
        return this.daoMapper.count(contextInstance);
    }

    @Override
    public int countBy(List<T> itemList, String ... searchColNames) {
        List<EntityContextInstance> contextInstanceList = itemList.stream().map(i -> EntityContextInstance.instance(i, new String[0])).collect(Collectors.toList());
        if (!ArrayUtils.isEmpty(searchColNames)) {
            contextInstanceList.forEach(i -> i.getColumnContextInstanceList().forEach(c -> c.setActive(ArrayUtils.containsIgnoreCase(searchColNames, c.getColumnContext().getColumnName()))));
        }
        return this.daoMapper.batchCount(this.getEntityContext(), contextInstanceList);
    }

    @Override
    public Page<T> selectPaginationByMybatis(String mybatisStatementId, Pageable pageable) {
        Map parameter = (Map)JSONObject.parseObject((String)pageable.getFilterJson(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        PageRowBounds rowBounds = new PageRowBounds(pageable);
        return MybatisPageHelper.get(rowBounds, () -> this.mybatisTemplate.selectList(mybatisStatementId, (Object)parameter));
    }

    private void preInsert(List<T> itemList) {
        boolean isOrderable = Orderable.class.isAssignableFrom(this.getType());
        List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(this.getType());
        List notNullPropertyDescriptorList = propertyDescriptorList.stream().filter(p -> p.isAnnotationPresent(NotNull.class)).collect(Collectors.toList());
        BeanPropertyDescriptor createdByIdDescriptor = propertyDescriptorList.stream().filter(PersistableMetadataHelper::isCreatedByIdPropertyDescriptor).findAny().orElse(null);
        BeanPropertyDescriptor createdByNameDescriptor = propertyDescriptorList.stream().filter(PersistableMetadataHelper::isCreatedByNamePropertyDescriptor).findAny().orElse(null);
        BeanPropertyDescriptor createdByOrgIdDescriptor = propertyDescriptorList.stream().filter(PersistableMetadataHelper::isCreatedByOrgIdPropertyDescriptor).findAny().orElse(null);
        BeanPropertyDescriptor createdByOrgNameDescriptor = propertyDescriptorList.stream().filter(PersistableMetadataHelper::isCreatedByOrgNamePropertyDescriptor).findAny().orElse(null);
        BeanPropertyDescriptor createdTimeDescriptor = propertyDescriptorList.stream().filter(PersistableMetadataHelper::isCreatedTimePropertyDescriptor).findAny().orElse(null);
        String createdById = LocalContextHelper.getLoginUserId();
        String createdByName = LocalContextHelper.getLoginUserName();
        String createdByOrgId = LocalContextHelper.getLoginOrgId();
        String createdByOrgName = LocalContextHelper.getLoginOrgName();
        LocalDate nowDate = LocalDate.now();
        LocalDateTime nowTime = LocalDateTime.now();
        int j = itemList.size();
        for (int i = 0; i < j; ++i) {
            Orderable orderable;
            Persistable item = (Persistable)itemList.get(i);
            if (createdByIdDescriptor != null && createdByIdDescriptor.getPropertyValue(item) == null) {
                createdByIdDescriptor.setPropertyValue(item, createdById);
            }
            if (createdByNameDescriptor != null && createdByNameDescriptor.getPropertyValue(item) == null) {
                createdByNameDescriptor.setPropertyValue(item, createdByName);
            }
            if (createdByOrgIdDescriptor != null && createdByOrgIdDescriptor.getPropertyValue(item) == null) {
                createdByOrgIdDescriptor.setPropertyValue(item, createdByOrgId);
            }
            if (createdByOrgNameDescriptor != null && createdByOrgNameDescriptor.getPropertyValue(item) == null) {
                createdByOrgNameDescriptor.setPropertyValue(item, createdByOrgName);
            }
            if (createdTimeDescriptor != null && createdTimeDescriptor.getPropertyValue(item) == null) {
                createdTimeDescriptor.setPropertyValue(item, nowTime);
            }
            if (!notNullPropertyDescriptorList.isEmpty()) {
                for (BeanPropertyDescriptor notNullPropertyDescriptor : notNullPropertyDescriptorList) {
                    if (notNullPropertyDescriptor.getPropertyValue(item) != null) continue;
                    NotNull notNull = notNullPropertyDescriptor.getProperty().getAnnotation(NotNull.class);
                    notNullPropertyDescriptor.setPropertyValue(item, notNull.defaultValue());
                }
            }
            if (!isOrderable || (orderable = (Orderable)item).getOrderNo() != null) continue;
            orderable.setOrderNo(ApplicationContextHelper.getNextOrderNo());
        }
    }

    private List<Map<String, Object>> selectMapListByIdList(List<ID> idList, List<String> selectColNames, Order ... orders) {
        if (idList != null && !idList.isEmpty()) {
            ArrayList<String> cloneSelectColNames;
            ListChunkIterator<ID> chunkIterator = ListChunkIterator.of(idList, this.dialect.getInClauseIdMaxQty());
            boolean loop = idList.size() > this.dialect.getMaxParamQty();
            ArrayList<String> arrayList = cloneSelectColNames = selectColNames == null ? new ArrayList<String>() : new ArrayList<String>(selectColNames);
            if (loop && ArrayUtils.hasElement(orders)) {
                int var8 = orders.length;
                Arrays.stream(orders).filter(order -> cloneSelectColNames.stream().noneMatch(n -> n.equalsIgnoreCase(order.getColumn()))).forEach(order -> cloneSelectColNames.add(order.getColumn().toUpperCase()));
            }
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            while (chunkIterator.hasNext()) {
                if (loop) {
                    mapList.addAll(this.daoMapper.selectByIds(this.getEntityContext(), CollectionUtils.convert(chunkIterator.nextChunk(), Object.class), cloneSelectColNames, CollectionUtils.emptyList()));
                    continue;
                }
                mapList.addAll(this.daoMapper.selectByIds(this.getEntityContext(), CollectionUtils.convert(chunkIterator.nextChunk(), Object.class), cloneSelectColNames, ArrayUtils.asList(orders)));
            }
            if (!mapList.isEmpty() && loop && ArrayUtils.hasElement(orders)) {
                this.sort(mapList, orders);
            }
            return mapList;
        }
        return CollectionUtils.emptyList();
    }

    private List<Map<String, Object>> selectMapList(List<T> itemList, List<String> searchColNames, List<String> selectColNames, Order ... orders) {
        if (itemList != null && !itemList.isEmpty()) {
            ArrayList<String> cloneSelectColNames;
            long activeQty;
            List<EntityContextInstance> contextInstanceList = itemList.stream().map(i -> EntityContextInstance.instance(i, new String[0])).collect(Collectors.toList());
            if (searchColNames != null && !searchColNames.isEmpty()) {
                contextInstanceList.forEach(i -> i.getColumnContextInstanceList().forEach(c -> c.setActive(CollectionUtils.containsIgnoreCase(searchColNames, c.getColumnContext().getColumnName()))));
            }
            boolean loop = (activeQty = contextInstanceList.stream().mapToLong(i -> i.getColumnContextInstanceList().stream().filter(c -> c.isActive()).count()).max().getAsLong()) * (long)contextInstanceList.size() > (long)this.dialect.getMaxParamQty();
            ArrayList<String> arrayList = cloneSelectColNames = selectColNames == null ? new ArrayList<String>() : new ArrayList<String>(selectColNames);
            if (loop && ArrayUtils.hasElement(orders) && !cloneSelectColNames.isEmpty()) {
                int var11 = orders.length;
                Arrays.stream(orders).filter(order -> !CollectionUtils.containsIgnoreCase(cloneSelectColNames, order.getColumn())).forEach(order -> cloneSelectColNames.add(order.getColumn().toUpperCase()));
            }
            ListChunkIterator chunkIterator = ListChunkIterator.of(contextInstanceList, this.dialect.getMaxParamQty());
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            while (chunkIterator.hasNext()) {
                if (loop) {
                    mapList.addAll(this.daoMapper.batchSelect(this.getEntityContext(), chunkIterator.nextChunk(), cloneSelectColNames, CollectionUtils.emptyList()));
                    continue;
                }
                mapList.addAll(this.daoMapper.batchSelect(this.getEntityContext(), chunkIterator.nextChunk(), cloneSelectColNames, ArrayUtils.asList(orders)));
            }
            if (!mapList.isEmpty() && loop && ArrayUtils.hasElement(orders)) {
                this.sort(mapList, orders);
            }
            return mapList;
        }
        return CollectionUtils.emptyList();
    }

    private void auditUpdate(List<T> selectedOldItemList, List<T> selectedNewItemList) {
        if (AuditLogHelper.auditable(AuditDatabaseOperation.UPDATE)) {
            for (Persistable t : selectedOldItemList) {
                Persistable selectedNewItem = selectedNewItemList.stream().filter(i -> ((Serializable)t.getId()).equals(i.getId())).findAny().orElse(null);
                AuditLogHelper.insertAuditLog(this.getTable(), t, selectedNewItem);
            }
        }
    }

    private void sort(List<Map<String, Object>> mapList, Order ... orders) {
        mapList.sort((m1, m2) -> {
            int var4 = orders.length;
            for (Order order : orders) {
                Comparable v1 = (Comparable)CollectionUtils.getValueIgnorecase(m1, order.getColumn());
                Comparable v2 = (Comparable)CollectionUtils.getValueIgnorecase(m2, order.getColumn());
                if (v1 == null) {
                    if (v2 == null) continue;
                    if (StringUtils.endsWith(order.getDirection(), "ASC")) {
                        return -1;
                    }
                    return 1;
                }
                if (v2 == null) {
                    if (StringUtils.endsWith(order.getDirection(), "ASC")) {
                        return 1;
                    }
                    return -1;
                }
                int cv = v1.compareTo(v2);
                if (cv == 0) continue;
                if (StringUtils.endsWith(order.getDirection(), "ASC")) {
                    return cv;
                }
                return -1 * cv;
            }
            return 0;
        });
    }

    private boolean isCacheEvictOverrided() {
        GenericDao proxy = (GenericDao)SinoAopContext.currentProxy();
        Class<?> clazz = ClassUtils.getRawType(proxy.getClass());
        Method method = ReflectionUtils.findMethodByName(clazz, "cacheEvict");
        return !GenericDao.class.equals(method.getDeclaringClass());
    }
}

