/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.mybatis;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.exception.database.JdbcException;
import net.sinodawn.framework.mybatis.MybatisStrictMap;
import net.sinodawn.framework.support.base.mapper.GenericMapper;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MybatisHelper {
    private static final Logger logger = LogManager.getLogger(MybatisHelper.class);
    private static final ThreadLocal<String> KEY_PREFIX = new ThreadLocal();
    @Autowired
    private SqlSessionFactory sqlSessionFactory;
    private static SqlSessionFactory staticSqlSessionFactory;

    @PostConstruct
    public void init() {
        staticSqlSessionFactory = this.sqlSessionFactory;
    }

    public static SqlSessionFactory getSqlSessionFactory() {
        return staticSqlSessionFactory;
    }

    public static Connection getConnection() {
        try {
            return MybatisHelper.getSqlSessionFactory().getConfiguration().getEnvironment().getDataSource().getConnection();
        }
        catch (SQLException var1) {
            throw new JdbcException(var1);
        }
    }

    public static void updateRuntimeConfiguration() {
        Configuration configuration = MybatisHelper.getSqlSessionFactory().getConfiguration();
        String[] var1 = new String[]{"mappedStatements", "caches", "resultMaps", "parameterMaps", "keyGenerators", "sqlFragments"};
        int var2 = var1.length;
        for (String field : var1) {
            Map oldMap = (Map)ReflectionUtils.getFieldValue(configuration, field);
            MybatisStrictMap newMap = new MybatisStrictMap(field + " UpdatableCollection", oldMap);
            ReflectionUtils.setFieldValue(configuration, field, newMap);
        }
    }

    public static void setDraftMapper(String menuId, String mapperId) {
    }

    public static void removeDraftMapper(String menuId, String mapperId) {
        MybatisHelper.removeRuntimeMapper("draft$" + menuId + "$" + mapperId);
    }

    public static void removeRuntimeMapper(String resource) {
        Map mappedStatements;
        Configuration configuration = MybatisHelper.getSqlSessionFactory().getConfiguration();
        Set loadedResourcesSet = (Set)ReflectionUtils.getFieldValue(configuration, "loadedResources");
        if (loadedResourcesSet != null) {
            loadedResourcesSet.remove(resource);
        }
        if ((mappedStatements = (Map)ReflectionUtils.getFieldValue(configuration, "mappedStatements")) != null) {
            mappedStatements.remove(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRuntimeMapper(String mapperXmlContent, String prefix, String resource) {
        try {
            if (!StringUtils.isBlank(prefix)) {
                resource = prefix + "$" + (String)resource;
                MybatisHelper.setKeyPrefix(prefix);
            }
            Configuration configuration = MybatisHelper.getSqlSessionFactory().getConfiguration();
            Set loadedResourcesSet = (Set)ReflectionUtils.getFieldValue(configuration, "loadedResources");
            loadedResourcesSet.remove(resource);
            XMLMapperBuilder builder = new XMLMapperBuilder((InputStream)new ByteArrayInputStream(mapperXmlContent.getBytes()), configuration, (String)resource, configuration.getSqlFragments());
            builder.parse();
        }
        finally {
            MybatisHelper.removeKeyPrefix();
        }
    }

    public static String getStatementContent(String mappedStatementId) {
        int index;
        Configuration configuration = MybatisHelper.getSqlSessionFactory().getConfiguration();
        Map mappedStatements = (Map)ReflectionUtils.getFieldValue(configuration, "mappedStatements");
        MappedStatement ms = (MappedStatement)mappedStatements.get(mappedStatementId);
        String resource = ms.getResource();
        Object name = "/" + StringUtils.replace(resource.substring(index = Math.max(resource.lastIndexOf("com/sinoworld"), resource.lastIndexOf("com\\sinoworld"))), "\\", "/");
        if (!StringUtils.endsWith((String)name, "xml")) {
            int length = ((String)name).length();
            while (length > 0 && !StringUtils.endsWith((String)name, "xml")) {
                name = ((String)name).substring(0, length - 1);
                length = ((String)name).length();
            }
        }
        try {
            String var11;
            try (InputStream is = MybatisHelper.class.getResourceAsStream((String)name);){
                String mapperContent = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining(System.lineSeparator()));
                String simpleId = mappedStatementId.substring(mappedStatementId.lastIndexOf(".") + 1);
                var11 = mapperContent.replaceAll(MybatisHelper.getMapperSelectStatementRegex(simpleId), "");
            }
            return var11;
        }
        catch (IOException var23) {
            throw new UnexpectedException(var23);
        }
    }

    public static String getMapperContent(String mapperId) {
        int index;
        String mappedStatementId = mapperId + ".selectByCondition";
        Configuration configuration = MybatisHelper.getSqlSessionFactory().getConfiguration();
        Map mappedStatements = (Map)ReflectionUtils.getFieldValue(configuration, "mappedStatements");
        MappedStatement ms = (MappedStatement)mappedStatements.get(mappedStatementId);
        if (ms == null) {
            return null;
        }
        String resource = ms.getResource();
        Object name = "/" + StringUtils.replace(resource.substring(index = Math.max(resource.lastIndexOf("com/sinoworld"), resource.lastIndexOf("com\\sinoworld"))), "\\", "/");
        if (!StringUtils.endsWith((String)name, "xml")) {
            int length = ((String)name).length();
            while (length > 0 && !StringUtils.endsWith((String)name, "xml")) {
                name = ((String)name).substring(0, length - 1);
                length = ((String)name).length();
            }
        }
        try {
            String var10;
            try (InputStream is = MybatisHelper.class.getResourceAsStream((String)name);){
                var10 = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return var10;
        }
        catch (IOException var22) {
            throw new UnexpectedException(var22);
        }
    }

    public static String getMapperContent(Class<? extends GenericMapper<?>> mapperClazz) {
        return MybatisHelper.getMapperContent(mapperClazz.getName());
    }

    public static void setKeyPrefix(String prefix) {
        KEY_PREFIX.set(prefix);
    }

    public static void removeKeyPrefix() {
        KEY_PREFIX.remove();
    }

    public static String getKeyPrefix() {
        return KEY_PREFIX.get();
    }

    private static final String getMapperSelectStatementRegex(String statementId) {
        return "<(?i)select\\s*id=\"" + statementId + "[\\S\\s]+?<\\s*/(?i)select\\s*>";
    }
}

