/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.io.text.impl;

import java.io.IOException;
import java.io.InputStream;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.excel.ExcelHelper;
import net.sinodawn.framework.io.text.FileToTextExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelFileToTextFullExtractor
implements FileToTextExtractor {
    public static final ExcelFileToTextFullExtractor instance = new ExcelFileToTextFullExtractor();

    @Override
    public boolean match(String fileExtension) {
        return "xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension);
    }

    @Override
    public String extract(InputStream is) {
        try {
            String var25;
            try (Workbook wb = WorkbookFactory.create((InputStream)is);){
                int sheetNum = wb.getNumberOfSheets();
                StringBuilder sb = new StringBuilder();
                for (int sheetNo = 0; sheetNo < sheetNum; ++sheetNo) {
                    Sheet sheet = wb.getSheetAt(sheetNo);
                    if (wb.isSheetHidden(sheetNo)) continue;
                    sb.append("sheetName:").append(sheet.getSheetName()).append("\r\n");
                    int endRowNum = sheet.getLastRowNum() + 1;
                    for (int rowNum = sheet.getFirstRowNum(); rowNum <= endRowNum; ++rowNum) {
                        Row row = sheet.getRow(rowNum);
                        if (row == null) continue;
                        for (int cellIndex = row.getFirstCellNum(); cellIndex >= 0 && cellIndex <= row.getLastCellNum(); ++cellIndex) {
                            Cell cell = row.getCell(cellIndex);
                            String value = ExcelHelper.getCellValue(cell, String.class);
                            if ("".equals(value)) {
                                value = "\t";
                            }
                            sb.append(" ").append(value);
                        }
                        sb.append("\r\n");
                    }
                }
                var25 = sb.toString();
            }
            return var25;
        }
        catch (IOException var24) {
            throw new FileException(var24);
        }
    }
}

