/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.io.file;

import java.time.LocalDateTime;
import java.util.Objects;
import net.sinodawn.framework.io.file.FileScope;
import net.sinodawn.framework.utils.DateTimeUtils;

public class FilePathDTO {
    private FileScope scope;
    private String timestamp;
    private String irregularName;
    private String fileName;

    private FilePathDTO() {
    }

    public static final FilePathDTO of(String scope, String irregularName, String fileName) {
        return FilePathDTO.of(scope, "", irregularName, fileName);
    }

    public static final FilePathDTO of(String scope, LocalDateTime timestamp, String irregularName, String fileName) {
        return FilePathDTO.of(scope, DateTimeUtils.getDateSerialNumber(Objects.requireNonNull(timestamp)), irregularName, fileName);
    }

    public static final FilePathDTO of(String scope, String timestamp, String irregularName, String fileName) {
        FilePathDTO fileRepresentation = new FilePathDTO();
        fileRepresentation.scope = Objects.requireNonNull(FileScope.valueOf(scope));
        fileRepresentation.timestamp = timestamp;
        fileRepresentation.irregularName = Objects.requireNonNull(irregularName);
        fileRepresentation.fileName = Objects.requireNonNull(fileName);
        return fileRepresentation;
    }

    public FileScope getScope() {
        return this.scope;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getIrregularName() {
        return this.irregularName;
    }

    public void setScope(FileScope scope) {
        this.scope = scope;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setIrregularName(String irregularName) {
        this.irregularName = irregularName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

