/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.io.excel.support.impl;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.sinodawn.framework.io.excel.support.PropertyContext;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class DefaultPropertyContextImpl
implements PropertyContext {
    private String title;
    private String name;
    private HorizontalAlignment alignment;
    private BiConsumer<Cell, Object> styleConsumer;
    private Function<Object, Object> function;
    private boolean numeric = false;
    private BiConsumer<Cell, Object> cellRowItemConsumer;

    public static PropertyContext of(String title, String name) {
        return new DefaultPropertyContextImpl(title, name, null, null);
    }

    public static PropertyContext of(String title, String name, HorizontalAlignment alignment) {
        return new DefaultPropertyContextImpl(title, name, null, alignment);
    }

    public static PropertyContext of(String title, String name, Function<Object, Object> function) {
        return new DefaultPropertyContextImpl(title, name, function, null);
    }

    public static PropertyContext of(String title, String name, Function<Object, Object> function, HorizontalAlignment alignment) {
        return new DefaultPropertyContextImpl(title, name, function, alignment);
    }

    private DefaultPropertyContextImpl(String title, String name, Function<Object, Object> function, HorizontalAlignment alignment) {
        this.title = title;
        this.name = name;
        this.function = Optional.ofNullable(function).orElse(v -> v);
        this.alignment = Optional.ofNullable(alignment).orElse(HorizontalAlignment.CENTER);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Function<Object, Object> getConvertFunction() {
        return this.function;
    }

    @Override
    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public BiConsumer<Cell, Object> getCellRowItemConsumer() {
        return this.cellRowItemConsumer;
    }

    @Override
    public void setCellRowItemConsumer(BiConsumer<Cell, Object> cellRowItemConsumer) {
        this.cellRowItemConsumer = cellRowItemConsumer;
    }

    @Override
    public BiConsumer<Cell, Object> getStyleConsumer() {
        return this.styleConsumer;
    }

    @Override
    public void setStyleConsumer(BiConsumer<Cell, Object> styleConsumer) {
        this.styleConsumer = styleConsumer;
    }

    @Override
    public boolean isNumeric() {
        return this.numeric;
    }

    @Override
    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }
}

