/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.io.excel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.io.excel.BaseSheetWriter;
import net.sinodawn.framework.io.excel.ExcelHelper;
import net.sinodawn.framework.io.excel.support.PropertyContext;
import net.sinodawn.framework.io.excel.support.SheetContext;
import net.sinodawn.framework.io.excel.utils.ExcelUtils;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class DefaultSheetWriter
extends BaseSheetWriter {
    public DefaultSheetWriter(SheetContext sheetContext, List<? extends Object> items) {
        super(sheetContext, items);
    }

    @Override
    public void write(Workbook wb) {
        int mergeCellsForSumTitle;
        Pair<Integer, Integer> pos;
        boolean belongsToSubTitle;
        int i;
        SheetContext sheetContext = this.getSheetContext();
        Sheet sheet = wb.createSheet(ExcelUtils.getWellFormedSheetName(sheetContext.getSheetName()));
        Row row = null;
        Cell cell = null;
        CellStyle csForTopic = ExcelUtils.getTopicCellStyle(wb);
        CellStyle csForTitle = ExcelUtils.getTitleCellStyle(wb);
        CellStyle csForCenterContent = ExcelUtils.getCenterCellStyle(wb);
        CellStyle csForLeftContent = ExcelUtils.getLeftCellStyle(wb);
        CellStyle csForRightContent = ExcelUtils.getRightCellStyle(wb);
        CellStyle csForFooterCenter = ExcelUtils.getFooterCenterCellStyle(wb);
        CellStyle csForFooterRight = ExcelUtils.getFooterRightCellStyle(wb);
        int rowNumber = 0;
        List<PropertyContext> propertyContextList = sheetContext.getPropertyList();
        int[] cellMaxWidth = new int[propertyContextList.size() + 1];
        row = sheet.createRow(0);
        cell = row.createCell(0);
        cell.setCellStyle(csForTopic);
        ExcelHelper.setCellStringValue(sheetContext.getTopic(), cell, wb);
        for (int i2 = 1; i2 <= propertyContextList.size(); ++i2) {
            cell = row.createCell(i2);
            cell.setCellValue("");
            cell.setCellStyle(csForTopic);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, propertyContextList.size()));
        ++rowNumber;
        List<Pair<String, Pair<Integer, Integer>>> subTopicList = sheetContext.getSubTopicList();
        if (!subTopicList.isEmpty()) {
            row = sheet.createRow(rowNumber);
            for (i = 0; i <= propertyContextList.size(); ++i) {
                cell = row.createCell(i);
                belongsToSubTitle = false;
                for (Pair<String, Pair<Integer, Integer>> subTopic : subTopicList) {
                    pos = subTopic.getSecond();
                    if (pos.getFirst() != i) continue;
                    ExcelHelper.setCellStringValue(subTopic.getFirst(), cell, wb);
                    belongsToSubTitle = true;
                    break;
                }
                if (!belongsToSubTitle) {
                    cell.setCellValue("");
                }
                cell.setCellStyle(csForTitle);
            }
            for (Pair<String, Pair<Integer, Integer>> subTopic1 : subTopicList) {
                Pair<Integer, Integer> pos1 = subTopic1.getSecond();
                if (pos1.getSecond() <= pos1.getFirst()) continue;
                sheet.addMergedRegion(new CellRangeAddress(1, 1, pos1.getFirst().intValue(), pos1.getSecond().intValue()));
            }
            ++rowNumber;
        }
        row = sheet.createRow(rowNumber);
        cell = row.createCell(0);
        cell.setCellValue("\u5e8f\u53f7");
        cell.setCellStyle(csForTitle);
        cellMaxWidth[0] = ExcelUtils.getCellWidth("\u5e8f\u53f7");
        for (i = 0; i < propertyContextList.size(); ++i) {
            PropertyContext propertyContext = propertyContextList.get(i);
            cell = row.createCell(i + 1);
            cell.setCellStyle(csForTitle);
            ExcelHelper.setCellStringValue(propertyContext.getTitle(), cell, wb);
            cellMaxWidth[i + 1] = ExcelUtils.getCellWidth(propertyContext.getTitle());
        }
        if (!subTopicList.isEmpty()) {
            for (i = 0; i <= propertyContextList.size(); ++i) {
                belongsToSubTitle = false;
                for (Pair<String, Pair<Integer, Integer>> subTopic : subTopicList) {
                    pos = subTopic.getSecond();
                    if (i < pos.getFirst() || i > pos.getSecond()) continue;
                    belongsToSubTitle = true;
                    break;
                }
                if (belongsToSubTitle) continue;
                sheet.getRow(1).getCell(i).setCellValue(sheet.getRow(2).getCell(i).getStringCellValue());
                sheet.addMergedRegion(new CellRangeAddress(1, 2, i, i));
            }
        }
        ++rowNumber;
        LinkedHashMap<String, Double> sumMap = new LinkedHashMap<String, Double>();
        List<Pair<String, List<String>>> mergePropertyPairList = sheetContext.getMergePropertyPairList();
        HashMap<String, CellMergeInstance> mergeInstanceMap = new HashMap<String, CellMergeInstance>();
        i = this.getItems().size();
        for (mergeCellsForSumTitle = 0; mergeCellsForSumTitle < i; ++mergeCellsForSumTitle) {
            Object item = this.getItems().get(mergeCellsForSumTitle);
            row = sheet.createRow(rowNumber);
            cell = row.createCell(0);
            cell.setCellValue((double)(mergeCellsForSumTitle + 1));
            cell.setCellStyle(csForCenterContent);
            int length = ExcelUtils.getCellWidth("" + mergeCellsForSumTitle);
            if (cellMaxWidth[0] < length) {
                cellMaxWidth[0] = length;
            }
            int ps = propertyContextList.size();
            for (int j = 0; j < ps; ++j) {
                Pair pair;
                boolean hasStyle;
                PropertyContext propertyContext = propertyContextList.get(j);
                cell = row.createCell(j + 1);
                Object value = this.getPropertyValue(item, propertyContext.getName());
                boolean isNumeric = false;
                if (!Map.class.isAssignableFrom(this.getItemClass())) {
                    BeanPropertyDescriptor propertyDescriptor = BeanPropertyDescriptor.of(item.getClass(), propertyContext.getName());
                    if (propertyDescriptor != null && propertyDescriptor.getProperty() != null && Double.class.equals(propertyDescriptor.getPropertyType())) {
                        isNumeric = true;
                    }
                } else {
                    isNumeric = value != null && Double.class.equals(value.getClass());
                }
                boolean bl = hasStyle = propertyContext.getStyleConsumer() != null;
                if (isNumeric) {
                    if (hasStyle) {
                        cell.setCellStyle(ExcelUtils.getRightCellStyle(wb));
                    } else {
                        cell.setCellStyle(csForRightContent);
                    }
                } else if (hasStyle) {
                    if (HorizontalAlignment.LEFT.equals((Object)propertyContext.getAlignment())) {
                        cell.setCellStyle(ExcelUtils.getLeftCellStyle(wb));
                    } else if (HorizontalAlignment.RIGHT.equals((Object)propertyContext.getAlignment())) {
                        cell.setCellStyle(ExcelUtils.getRightCellStyle(wb));
                    } else {
                        cell.setCellStyle(ExcelUtils.getCenterCellStyle(wb));
                    }
                } else if (HorizontalAlignment.LEFT.equals((Object)propertyContext.getAlignment())) {
                    cell.setCellStyle(csForLeftContent);
                } else if (HorizontalAlignment.RIGHT.equals((Object)propertyContext.getAlignment())) {
                    cell.setCellStyle(csForRightContent);
                } else {
                    cell.setCellStyle(csForCenterContent);
                }
                if (propertyContext.getCellRowItemConsumer() != null) {
                    propertyContext.getCellRowItemConsumer().accept(cell, item);
                }
                if (hasStyle) {
                    propertyContext.getStyleConsumer().accept(cell, item);
                }
                if (value != null) {
                    Object convertedValue = propertyContext.getConvertFunction().apply(value);
                    if (propertyContext.isNumeric()) {
                        cell.setCellValue(((Double)convertedValue).doubleValue());
                    } else {
                        ExcelHelper.setCellStringValue((String)convertedValue, cell, wb);
                    }
                    length = ExcelUtils.getCellWidth(ConvertUtils.convert(convertedValue, String.class));
                    if (cellMaxWidth[j + 1] < length) {
                        cellMaxWidth[j + 1] = length;
                    }
                    if (this.getSheetContext().getSumPropertyList().stream().anyMatch(n -> propertyContext.getName().equalsIgnoreCase((String)n.getFirst()))) {
                        double sum = ConvertUtils.convert((Double)sumMap.get(propertyContext.getName()), Double.TYPE);
                        sumMap.put(propertyContext.getName(), sum += ConvertUtils.convert(value, Double.TYPE).doubleValue());
                    }
                } else {
                    cell.setBlank();
                }
                if (mergePropertyPairList.isEmpty() || (pair = (Pair)mergePropertyPairList.stream().filter(p -> ((String)p.getFirst()).equalsIgnoreCase(propertyContext.getName())).findFirst().orElse(null)) == null) continue;
                CellMergeInstance mergeInstance = (CellMergeInstance)mergeInstanceMap.get(pair.getFirst());
                if (mergeInstance == null) {
                    CellMergeInstance instance = new CellMergeInstance(propertyContext.getName(), (List)pair.getSecond(), rowNumber, j + 1);
                    ArrayList<Object> valueList = new ArrayList<Object>();
                    for (String name : (List)pair.getSecond()) {
                        valueList.add(this.getPropertyValue(item, name));
                    }
                    instance.setComparisionValueList(valueList);
                    mergeInstanceMap.put((String)pair.getFirst(), instance);
                    continue;
                }
                if (this.isMergeRow(item, mergeInstance)) continue;
                if (mergeInstance.getStartRowIndex() + 1 < rowNumber) {
                    sheet.addMergedRegion(new CellRangeAddress(mergeInstance.getStartRowIndex(), rowNumber - 1, mergeInstance.getColumnIndex(), mergeInstance.getColumnIndex()));
                }
                mergeInstance.setStartRowIndex(rowNumber);
                ArrayList<Object> valueList = new ArrayList<Object>();
                for (String name : (List)pair.getSecond()) {
                    valueList.add(this.getPropertyValue(item, name));
                }
                mergeInstance.setComparisionValueList(valueList);
            }
            ++rowNumber;
        }
        if (!sumMap.isEmpty()) {
            row = sheet.createRow(rowNumber);
            cell = row.createCell(0);
            cell.setCellValue("\u5408\u8ba1\uff1a");
            cell.setCellStyle(csForFooterCenter);
            mergeCellsForSumTitle = -1;
            int ps = propertyContextList.size();
            for (i = 0; i < ps; ++i) {
                PropertyContext propertyContext = propertyContextList.get(i);
                cell = row.createCell(i + 1);
                cell.setCellStyle(csForFooterRight);
                Double sum = (Double)sumMap.get(propertyContext.getName());
                if (sum != null) {
                    if (mergeCellsForSumTitle == -1) {
                        mergeCellsForSumTitle = i;
                    }
                    Function function = (Function)this.getSheetContext().getSumPropertyList().stream().filter(n -> propertyContext.getName().equalsIgnoreCase((String)n.getFirst())).findFirst().get().getSecond();
                    String stringValue = (String)function.apply(sum);
                    cell.setCellValue(ConvertUtils.convert(stringValue, Double.class).doubleValue());
                    int length = ExcelUtils.getCellWidth(stringValue);
                    if (cellMaxWidth[i + 1] >= length) continue;
                    cellMaxWidth[i + 1] = length;
                    continue;
                }
                cell.setBlank();
            }
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, mergeCellsForSumTitle));
        }
        for (mergeCellsForSumTitle = 0; mergeCellsForSumTitle < cellMaxWidth.length; ++mergeCellsForSumTitle) {
            i = cellMaxWidth[mergeCellsForSumTitle] + 512;
            if (i > 15360) {
                i = 15360;
            }
            sheet.setColumnWidth(mergeCellsForSumTitle, i);
        }
        if (subTopicList.isEmpty()) {
            sheet.createFreezePane(1, 2);
        } else {
            sheet.createFreezePane(1, 3);
        }
    }

    private Object getPropertyValue(Object item, String propertyName) {
        if (item != null && propertyName != null) {
            Map.Entry entry;
            if (Map.class.isAssignableFrom(this.getItemClass())) {
                Map item1 = (Map)item;
                return item1.entrySet().stream().filter(e -> propertyName.equalsIgnoreCase((String)e.getKey())).map(e -> ObjectUtils.isEmpty(e.getValue()) ? "" : e.getValue()).findFirst().orElse(null);
            }
            BeanPropertyDescriptor propertyDescriptor = BeanPropertyDescriptor.of(item.getClass(), propertyName);
            if (propertyDescriptor != null) {
                return ReflectionUtils.invokeMethod(propertyDescriptor.getReadMethod(), item, new Object[0]);
            }
            if (BaseData.class.isAssignableFrom(item.getClass()) && (entry = (Map.Entry)((BaseData)item).getExt$().entrySet().stream().filter(e -> propertyName.equalsIgnoreCase((String)e.getKey())).findFirst().orElse(null)) != null) {
                return entry.getValue();
            }
            return null;
        }
        return null;
    }

    private boolean isMergeRow(Object item, CellMergeInstance mergeInstance) {
        List<String> comparisionPropertyList = mergeInstance.getComparisionPropertyList();
        for (int i = 0; i < comparisionPropertyList.size(); ++i) {
            Object comparisionValue;
            Object value = this.getPropertyValue(item, comparisionPropertyList.get(i));
            if (ObjectUtils.equals(value, comparisionValue = mergeInstance.getComparisionValueList().get(i))) continue;
            return false;
        }
        return true;
    }

    public static class CellMergeInstance {
        private String property;
        private List<String> comparisionPropertyList;
        private int startRowIndex;
        private int columnIndex;
        private List<Object> comparisionValueList;

        public CellMergeInstance(String property, List<String> comparisionPropertyList, int startRowIndex, int columnIndex) {
            this.property = property;
            this.comparisionPropertyList = comparisionPropertyList;
            this.startRowIndex = startRowIndex;
            this.columnIndex = columnIndex;
        }

        public int getStartRowIndex() {
            return this.startRowIndex;
        }

        public void setStartRowIndex(int startRowIndex) {
            this.startRowIndex = startRowIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public List<String> getComparisionPropertyList() {
            return this.comparisionPropertyList;
        }

        public void setComparisionPropertyList(List<String> comparisionPropertyList) {
            this.comparisionPropertyList = comparisionPropertyList;
        }

        public List<Object> getComparisionValueList() {
            return this.comparisionValueList;
        }

        public void setComparisionValueList(List<Object> comparisionValueList) {
            this.comparisionValueList = comparisionValueList;
        }
    }
}

