/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.io.excel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.excel.impl.DefaultExcelWriter;
import net.sinodawn.framework.io.excel.impl.DefaultSheetWriter;
import net.sinodawn.framework.io.excel.support.SheetContext;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelHelper {
    private static final String SUP_MARK_START = "<sup>";
    private static final String SUP_MARK_END = "</sup>";
    private static final String SUB_MARK_START = "<sub>";
    private static final String SUB_MARK_END = "</sub>";
    private static final String BR_MARK_START = "<br>";
    private static final String BR_MARK_END = "</br>";

    public static final <T> T getCellValue(Cell cell, Class<T> clazz) {
        Object cellValue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case STRING: {
                    cellValue = StringUtils.trim(cell.getRichStringCellValue().getString());
                    break;
                }
                case NUMERIC: {
                    short format = cell.getCellStyle().getDataFormat();
                    if (format != 14 && format != 22 && format != 31 && format != 57 && format != 58 && format != 20 && format != 32) {
                        cellValue = cell.getNumericCellValue();
                        break;
                    }
                    cellValue = DateUtil.getJavaDate((double)cell.getNumericCellValue());
                    break;
                }
                case BOOLEAN: {
                    cellValue = ObjectUtils.toString(cell.getBooleanCellValue());
                    break;
                }
                case FORMULA: {
                    FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                    CellValue cv = evaluator.evaluate(cell);
                    switch (cv.getCellType()) {
                        case STRING: {
                            cellValue = StringUtils.trim(cv.getStringValue());
                            return ConvertUtils.convert(cellValue, clazz);
                        }
                        case NUMERIC: {
                            cellValue = cv.getNumberValue();
                            return ConvertUtils.convert(cellValue, clazz);
                        }
                        case BOOLEAN: {
                            cellValue = ObjectUtils.toString(cv.getBooleanValue());
                            return ConvertUtils.convert(cellValue, clazz);
                        }
                    }
                    cellValue = null;
                    return ConvertUtils.convert(cellValue, clazz);
                }
                default: {
                    cellValue = "";
                }
            }
        }
        return ConvertUtils.convert(cellValue, clazz);
    }

    public static <T> T getCellValue(Cell cell, Class<?> clazz, String propertyName) {
        Class<Object> propertyType;
        Object cellValue = "";
        BeanPropertyDescriptor propertyDescriptor = BeanPropertyDescriptor.of(clazz, propertyName);
        Class<?> clazz2 = propertyType = propertyDescriptor == null ? null : propertyDescriptor.getPropertyType();
        if (cell != null) {
            block0 : switch (cell.getCellType()) {
                case STRING: {
                    cellValue = StringUtils.trim(cell.getRichStringCellValue().getString());
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue();
                        break;
                    }
                    cellValue = cell.getNumericCellValue();
                    break;
                }
                case BOOLEAN: {
                    cellValue = ObjectUtils.toString(cell.getBooleanCellValue());
                    break;
                }
                case FORMULA: {
                    FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                    CellValue cv = evaluator.evaluate(cell);
                    switch (cv.getCellType()) {
                        case STRING: {
                            cellValue = StringUtils.trim(cv.getStringValue());
                            break block0;
                        }
                        case NUMERIC: {
                            cellValue = "" + cv.getNumberValue();
                            break block0;
                        }
                        case BOOLEAN: {
                            cellValue = ObjectUtils.toString(cv.getBooleanValue());
                            break block0;
                        }
                    }
                    cellValue = null;
                    break;
                }
                default: {
                    cellValue = "";
                }
            }
        }
        propertyType = propertyType == null ? String.class : propertyType;
        Object value = ConvertUtils.convert(cellValue, propertyType);
        return (T)value;
    }

    public static boolean canConvertCellValue(Cell cell, Class<?> targetType) {
        if (cell != null && targetType != null) {
            Object cellValue = "";
            switch (cell.getCellType()) {
                case STRING: {
                    cellValue = StringUtils.trim(cell.getRichStringCellValue().getString());
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue();
                        break;
                    }
                    cellValue = cell.getNumericCellValue();
                    break;
                }
                case BOOLEAN: {
                    cellValue = ObjectUtils.toString(cell.getBooleanCellValue());
                    break;
                }
                case FORMULA: {
                    FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                    CellValue cv = evaluator.evaluate(cell);
                    switch (cv.getCellType()) {
                        case STRING: {
                            cellValue = StringUtils.trim(cv.getStringValue());
                            return ConvertUtils.canConvert(cellValue, targetType);
                        }
                        case NUMERIC: {
                            cellValue = "" + cv.getNumberValue();
                            return ConvertUtils.canConvert(cellValue, targetType);
                        }
                        case BOOLEAN: {
                            cellValue = ObjectUtils.toString(cv.getBooleanValue());
                            return ConvertUtils.canConvert(cellValue, targetType);
                        }
                    }
                    cellValue = null;
                    return ConvertUtils.canConvert(cellValue, targetType);
                }
                default: {
                    cellValue = "";
                }
            }
            return ConvertUtils.canConvert(cellValue, targetType);
        }
        return true;
    }

    public static void setCellStringValue(String text, Cell cell, Workbook wb) {
        if (text == null) {
            text = "";
        }
        if (StringUtils.contains(text = text.replaceAll("</?p>", ""), BR_MARK_START)) {
            CellStyle cellStyle = cell.getCellStyle();
            cellStyle.setWrapText(true);
            text = StringUtils.replace(text, BR_MARK_START, "\n");
            text = StringUtils.replace(text, BR_MARK_END, "");
            cell.setCellStyle(cellStyle);
        }
        if (ExcelHelper.containCornerMark(text)) {
            RichTextString richTextString = ExcelHelper.replaceCornerMarkToText(text, wb);
            cell.setCellValue(richTextString);
        } else {
            cell.setCellValue(text);
        }
    }

    public static boolean containCornerMark(String text) {
        return StringUtils.contains(text, SUB_MARK_START) || StringUtils.contains(text, SUP_MARK_START);
    }

    public static RichTextString replaceCornerMarkToText(String text, Workbook wb) {
        String subTmp2;
        RichTextString richText = wb.getCreationHelper().createRichTextString(text.replaceAll("</?su[b,p]>", ""));
        Font supFont = wb.createFont();
        supFont.setTypeOffset((short)1);
        String supTmp = text.replaceAll("</?sub>", "");
        List<String> supList = StringUtils.substringsBetween(text, SUP_MARK_START, SUP_MARK_END);
        for (String subTmp2 : supList) {
            int index = supTmp.indexOf(SUP_MARK_START + subTmp2 + SUP_MARK_END);
            if (index == -1) continue;
            richText.applyFont(index, index + subTmp2.length(), supFont);
            supTmp = supTmp.replaceFirst(SUP_MARK_START, "").replaceFirst(SUP_MARK_END, "");
        }
        Font subFont = wb.createFont();
        subFont.setTypeOffset((short)2);
        subTmp2 = text.replaceAll("</?sup>", "");
        List<String> subList = StringUtils.substringsBetween(text, SUB_MARK_START, SUB_MARK_END);
        for (String sub : subList) {
            int index = subTmp2.indexOf(SUB_MARK_START + sub + SUB_MARK_END);
            if (index == -1) continue;
            richText.applyFont(index, index + sub.length(), subFont);
            subTmp2 = subTmp2.replaceFirst(SUB_MARK_START, "").replaceFirst(SUB_MARK_END, "");
        }
        return richText;
    }

    public static <T extends BaseData> void writeAsExcel(File file, String name, SheetContext sheetContext, List<T> itemList) {
        DefaultSheetWriter writer = new DefaultSheetWriter(sheetContext, itemList);
        DefaultExcelWriter excelWriter = new DefaultExcelWriter(writer);
        try (FileOutputStream fos = new FileOutputStream(file);){
            excelWriter.write(fos);
        }
        catch (IOException var19) {
            throw new FileException(var19);
        }
    }

    /*
     * Exception decompiling
     */
    public static <T extends BaseData> FilePathDTO writeImportFailureListAsExcel(String filePath, List<T> itemList, int headerIndex, int validIndex, String errorFileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends BaseData> List<T> readDataFromExcel(String filePath, int headerRowIndex, int dataFromRowIndex, Class<T> clazz) {
        return ExcelHelper.readDataFromExcel(filePath, 0, headerRowIndex, dataFromRowIndex, clazz, null);
    }

    public static <T extends BaseData> List<T> readDataFromExcel(String filePath, int headerRowIndex, int dataFromRowIndex, Class<T> clazz, String masterPropertyName) {
        return ExcelHelper.readDataFromExcel(filePath, 0, headerRowIndex, dataFromRowIndex, clazz, masterPropertyName);
    }

    public static <T extends BaseData> List<T> readDataFromExcel(String filePath, int sheetIndex, int headerRowIndex, int dataFromRowIndex, Class<T> clazz) {
        return ExcelHelper.readDataFromExcel(filePath, sheetIndex, headerRowIndex, dataFromRowIndex, clazz, null);
    }

    public static <T extends BaseData> List<T> readDataFromExcel(String filePath, String sheetName, int headerRowIndex, int dataFromRowIndex, Class<T> clazz) {
        return ExcelHelper.extractDataFromExcel(filePath, sheetName, headerRowIndex, dataFromRowIndex, clazz, null);
    }

    public static <T extends BaseData> List<T> readDataFromExcel(String filePath, int sheetIndex, int headerRowIndex, int dataFromRowIndex, Class<T> clazz, String masterPropertyName) {
        return ExcelHelper.extractDataFromExcel(filePath, sheetIndex, headerRowIndex, dataFromRowIndex, clazz, masterPropertyName);
    }

    /*
     * Exception decompiling
     */
    private static <T extends BaseData> List<T> extractDataFromExcel(String filePath, Object sheetIndexOrSheetName, int headerRowIndex, int dataFromRowIndex, Class<T> clazz, String masterPropertyName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void updateValidationImpMsg(Map<String, Object> map, String msg) {
        String origMsg = (String)map.get("validateimpmsg");
        if (StringUtils.isEmpty(origMsg)) {
            map.put("validateimpmsg", msg);
        } else {
            map.put("validateimpmsg", origMsg + "\uff1b" + msg);
        }
    }

    private static /* synthetic */ BaseData lambda$extractDataFromExcel$0(Class clazz, Map m) {
        return PersistableHelper.mapToPersistable(m, clazz);
    }
}

