/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class I18nHelper {
    private static MessageSource messageSource;

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        I18nHelper.messageSource = messageSource;
    }

    public static String getMessage(String key, String ... args) {
        return StringUtils.isBlank(key) ? "" : messageSource.getMessage(key, (Object[])args, LocaleContextHolder.getLocale());
    }

    public static String getLang(Locale locale) {
        StringBuilder sb = new StringBuilder(locale.getLanguage().toLowerCase());
        if (!StringUtils.isEmpty(locale.getCountry())) {
            sb.append("-").append(locale.getCountry().toLowerCase());
        }
        return sb.toString();
    }

    public Map<String, String> i18nMap() {
        return new HashMap<String, String>();
    }
}

