/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class DatabaseDrivenMessageSource
implements MessageSource {
    public DatabaseDrivenMessageSource(ApplicationContext applicationContext) {
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return Optional.ofNullable(this.resolveMessage(code, args, locale)).orElse(defaultMessage);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.resolveMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        for (String code : resolvable.getCodes()) {
            String message = this.resolveMessage(code, resolvable.getArguments(), locale);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private String resolveMessage(String code, Object[] args, Locale locale) {
        String message;
        StringBuilder sb = new StringBuilder(locale.getLanguage().toLowerCase());
        if (!StringUtils.isBlank(locale.getCountry())) {
            sb.append("-").append(locale.getCountry().toLowerCase());
        }
        String localeCode = sb.toString();
        HashMap messageMap = new HashMap();
        if (messageMap != null && (message = (String)messageMap.get(code)) != null) {
            if (ArrayUtils.isEmpty(args)) {
                return message;
            }
            return MessageFormat.format(message, args);
        }
        return code;
    }
}

