/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.http;

import java.io.File;
import java.io.InputStream;
import net.sinodawn.framework.http.HttpClientInterface;
import net.sinodawn.framework.http.HttpSimpleClient;
import net.sinodawn.framework.http.HttpsSimpleClient;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;

public class HttpClientManager
implements HttpClientInterface {
    private static HttpClientManager instance;

    private HttpClientManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientManager getInstance() {
        if (instance != null) return instance;
        Class<HttpClientManager> var0 = HttpClientManager.class;
        Class<HttpClientManager> clazz = HttpClientManager.class;
        synchronized (HttpClientManager.class) {
            if (instance != null) return instance;
            instance = new HttpClientManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String sendHttpGet(String url) {
        return this.getClient(url).sendHttpGet(url);
    }

    @Override
    public String sendHttpPost(String url, String jsonString) {
        return this.getClient(url).sendHttpPost(url, jsonString);
    }

    @Override
    public String sendHttpPut(String url, String jsonString) {
        return this.getClient(url).sendHttpPut(url, jsonString);
    }

    @Override
    public String sendHttpDelete(String url) {
        return this.getClient(url).sendHttpDelete(url);
    }

    @Override
    public String upload(String targetUrl, MultipartFile multipartFile) {
        return this.getClient(targetUrl).upload(targetUrl, multipartFile);
    }

    @Override
    public String upload(String targetUrl, File file) {
        return this.getClient(targetUrl).upload(targetUrl, file);
    }

    @Override
    public String upload(String targetUrl, String fileName, InputStream is) {
        return this.getClient(targetUrl).upload(targetUrl, fileName, is);
    }

    @Override
    public String upload(String targetUrl, String fileName, String sourceUrl) {
        return this.getClient(targetUrl).upload(targetUrl, fileName, sourceUrl);
    }

    @Override
    public <T> String upload(String targetUrl, MultipartFile multipartFile, @Nullable T param) {
        return this.getClient(targetUrl).upload(targetUrl, multipartFile, param);
    }

    @Override
    public <T> String upload(String targetUrl, File file, @Nullable T param) {
        return this.getClient(targetUrl).upload(targetUrl, file, param);
    }

    @Override
    public <T> String upload(String targetUrl, String fileName, InputStream is, @Nullable T param) {
        return this.getClient(targetUrl).upload(targetUrl, fileName, is, param);
    }

    @Override
    public <T> String upload(String targetUrl, String fileName, String sourceUrl, @Nullable T param) {
        return this.getClient(targetUrl).upload(targetUrl, fileName, sourceUrl, param);
    }

    @Override
    public void download(String sourceUrl, String targetPath) {
        this.getClient(sourceUrl).download(sourceUrl, targetPath);
    }

    @Override
    public void download(String sourceUrl, File targetFile) {
        this.getClient(sourceUrl).download(sourceUrl, targetFile);
    }

    @Override
    public InputStream download(String url) {
        return this.getClient(url).download(url);
    }

    private HttpClientInterface getClient(String url) {
        return StringUtils.startsWithIgnoreCase(url, "https:") ? HttpsSimpleClient.getInstance() : HttpSimpleClient.getInstance();
    }
}

