/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.exception.NetworkException;
import net.sinodawn.framework.http.HttpClientInterface;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;

public abstract class BaseHttpClient
implements HttpClientInterface {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";

    abstract CloseableHttpClient getHttpClient();

    protected RequestConfig getDefaultRequestConfig() {
        return RequestConfig.custom().setSocketTimeout(((Integer)ApplicationContextHelper.getEnvironment().getProperty("sino.http-client.socket-timeout", Integer.class, (Object)30000)).intValue()).setConnectTimeout(((Integer)ApplicationContextHelper.getEnvironment().getProperty("sino.http-client.connect-timeout", Integer.class, (Object)3000)).intValue()).build();
    }

    @Override
    public final String sendHttpGet(String url) {
        try {
            String var8;
            try (CloseableHttpClient httpClient = this.getHttpClient();){
                HttpGet httpGet = new HttpGet(url);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    HttpEntity body = response.getEntity();
                    var8 = EntityUtils.toString((HttpEntity)body, (String)DEFAULT_CHARSET_NAME);
                }
            }
            return var8;
        }
        catch (IOException var37) {
            throw new NetworkException(var37);
        }
    }

    @Override
    public final String sendHttpPost(String url, String jsonString) {
        try {
            String var10;
            try (CloseableHttpClient httpClient = this.getHttpClient();){
                if (jsonString == null) {
                    jsonString = "";
                }
                StringEntity postEntity = new StringEntity(jsonString, DEFAULT_CHARSET_NAME);
                postEntity.setContentEncoding(DEFAULT_CHARSET_NAME);
                postEntity.setContentType("application/json");
                HttpPost httpPost = new HttpPost(url);
                httpPost.setEntity((HttpEntity)postEntity);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                    HttpEntity body = response.getEntity();
                    var10 = EntityUtils.toString((HttpEntity)body, (String)DEFAULT_CHARSET_NAME);
                }
            }
            return var10;
        }
        catch (IOException var39) {
            throw new NetworkException(var39);
        }
    }

    @Override
    public final String sendHttpPut(String url, String jsonString) {
        try {
            String var10;
            try (CloseableHttpClient httpClient = this.getHttpClient();){
                if (jsonString == null) {
                    jsonString = "";
                }
                StringEntity postEntity = new StringEntity(jsonString, DEFAULT_CHARSET_NAME);
                postEntity.setContentEncoding(DEFAULT_CHARSET_NAME);
                postEntity.setContentType("application/json");
                HttpPut httpPut = new HttpPut(url);
                httpPut.setEntity((HttpEntity)postEntity);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);){
                    HttpEntity body = response.getEntity();
                    var10 = EntityUtils.toString((HttpEntity)body, (String)DEFAULT_CHARSET_NAME);
                }
            }
            return var10;
        }
        catch (IOException var39) {
            throw new NetworkException(var39);
        }
    }

    @Override
    public final String sendHttpDelete(String url) {
        try {
            String var8;
            try (CloseableHttpClient httpClient = this.getHttpClient();){
                HttpDelete httpDelete = new HttpDelete(url);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);){
                    HttpEntity body = response.getEntity();
                    var8 = EntityUtils.toString((HttpEntity)body, (String)DEFAULT_CHARSET_NAME);
                }
            }
            return var8;
        }
        catch (IOException var37) {
            throw new NetworkException(var37);
        }
    }

    @Override
    public final String upload(String targetUrl, MultipartFile multipartFile) {
        return this.upload(targetUrl, multipartFile, null);
    }

    @Override
    public final String upload(String targetUrl, File file) {
        return this.upload(targetUrl, file, null);
    }

    @Override
    public final String upload(String targetUrl, String fileName, InputStream is) {
        return this.upload(targetUrl, fileName, is, null);
    }

    @Override
    public final String upload(String targetUrl, String fileName, String sourceUrl) {
        return this.upload(targetUrl, fileName, sourceUrl, null);
    }

    @Override
    public final <T> String upload(String targetUrl, MultipartFile multipartFile, @Nullable T item) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        try {
            builder.addBinaryBody("file", multipartFile.getInputStream(), ContentType.DEFAULT_BINARY, this.getOriginalFilename(multipartFile.getOriginalFilename()));
        }
        catch (IOException var10) {
            throw new FileException(var10);
        }
        if (item != null) {
            List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
            for (BeanPropertyDescriptor propertyDescriptor : propertyDescriptorList) {
                String strValue;
                Object value = propertyDescriptor.getPropertyValue(item);
                if (value == null || !ConvertUtils.canConvert(value, String.class) || StringUtils.isBlank(strValue = ConvertUtils.convert(value, String.class))) continue;
                builder.addPart(propertyDescriptor.getName(), (ContentBody)new StringBody(strValue, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
        }
        return this.upload(targetUrl, builder);
    }

    @Override
    public final <T> String upload(String targetUrl, File file, @Nullable T item) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addBinaryBody("file", file);
        if (item != null) {
            List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
            for (BeanPropertyDescriptor propertyDescriptor : propertyDescriptorList) {
                String strValue;
                Object value = propertyDescriptor.getPropertyValue(item);
                if (value == null || !ConvertUtils.canConvert(value, String.class) || StringUtils.isBlank(strValue = ConvertUtils.convert(value, String.class))) continue;
                builder.addPart(propertyDescriptor.getName(), (ContentBody)new StringBody(strValue, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
        }
        return this.upload(targetUrl, builder);
    }

    @Override
    public final <T> String upload(String targetUrl, String fileName, InputStream is, @Nullable T item) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addBinaryBody("file", is, ContentType.DEFAULT_BINARY, fileName);
        if (item != null) {
            List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
            for (BeanPropertyDescriptor propertyDescriptor : propertyDescriptorList) {
                String strValue;
                Object value = propertyDescriptor.getPropertyValue(item);
                if (value == null || !ConvertUtils.canConvert(value, String.class) || StringUtils.isBlank(strValue = ConvertUtils.convert(value, String.class))) continue;
                builder.addPart(propertyDescriptor.getName(), (ContentBody)new StringBody(strValue, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
        }
        return this.upload(targetUrl, builder);
    }

    @Override
    public final <T> String upload(String targetUrl, String fileName, String sourceUrl, @Nullable T item) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        try {
            String var45;
            try (CloseableHttpClient httpClient = this.getHttpClient();){
                HttpGet httpGet = new HttpGet(sourceUrl);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    InputStream is = response.getEntity().getContent();
                    builder.addBinaryBody("file", is, ContentType.DEFAULT_BINARY, fileName);
                    if (item != null) {
                        List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
                        for (BeanPropertyDescriptor propertyDescriptor : propertyDescriptorList) {
                            String strValue;
                            Object value = propertyDescriptor.getPropertyValue(item);
                            if (value == null || !ConvertUtils.canConvert(value, String.class) || StringUtils.isBlank(strValue = ConvertUtils.convert(value, String.class))) continue;
                            builder.addPart(propertyDescriptor.getName(), (ContentBody)new StringBody(strValue, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
                        }
                    }
                    var45 = this.upload(targetUrl, builder);
                }
            }
            return var45;
        }
        catch (IOException var44) {
            throw new NetworkException(var44);
        }
    }

    @Override
    public final void download(String sourceUrl, String targetPath) {
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpGet httpGet = new HttpGet(sourceUrl);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                InputStream is = response.getEntity().getContent();
                File target = new File(targetPath);
                FileUtils.createFile(target);
                FileUtils.write(target, is);
            }
        }
        catch (IOException var37) {
            throw new NetworkException(var37);
        }
    }

    @Override
    public final void download(String sourceUrl, File targetFile) {
        FileUtils.makeDirs(targetFile.toPath());
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpGet httpGet = new HttpGet(sourceUrl);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                InputStream is = response.getEntity().getContent();
                FileUtils.write(targetFile, is);
            }
        }
        catch (IOException var36) {
            throw new NetworkException(var36);
        }
    }

    @Override
    public InputStream download(String url) {
        try {
            InputStream var7;
            try (CloseableHttpClient httpClient = this.getHttpClient();){
                HttpGet httpGet = new HttpGet(url);
                Throwable var6 = null;
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    var7 = response.getEntity().getContent();
                }
                catch (Throwable var32) {
                    Throwable var72 = var32;
                    var6 = var32;
                    throw var32;
                }
            }
            return var7;
        }
        catch (IOException var36) {
            throw new NetworkException(var36);
        }
    }

    private final String upload(String targetUrl, MultipartEntityBuilder builder) {
        try {
            String var10;
            try (CloseableHttpClient httpClient = this.getHttpClient();){
                HttpPost httpPost = new HttpPost(targetUrl);
                HttpEntity multipartEntity = builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(StandardCharsets.UTF_8).build();
                httpPost.setEntity(multipartEntity);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new NetworkException(statusCode);
                    }
                    var10 = EntityUtils.toString((HttpEntity)response.getEntity());
                }
            }
            return var10;
        }
        catch (IOException var39) {
            throw new NetworkException(var39);
        }
    }

    private String getOriginalFilename(String filename) {
        int index = filename.lastIndexOf("\\");
        if (index >= 0) {
            return filename.substring(index + 1);
        }
        index = filename.lastIndexOf("/");
        return index > 0 ? filename.substring(index + 1) : filename;
    }
}

