/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.exception.advice;

import net.sinodawn.framework.exception.checked.CheckedException;
import net.sinodawn.framework.exception.core.ApplicationWarningException;
import net.sinodawn.framework.exception.core.HttpErrorMessage;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.utils.ServletUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@ControllerAdvice
@RestControllerAdvice
@Order(value=-2147483648)
public class GlobalExceptionHandler {
    private static final Logger logger = LogManager.getLogger(GlobalExceptionHandler.class);
    @Value(value="${sino.exception.viewable}")
    private boolean viewable;

    @Deprecated
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @Log(value="\u6570\u636e\u9a8c\u8bc1\u5f02\u5e38", type=LogType.EXCEPTION)
    public void handleCheckedException(CheckedException checkedException) {
    }

    @Deprecated
    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @Log(value="\u5185\u90e8\u5f02\u5e38", type=LogType.EXCEPTION)
    public void handleThrowable(Throwable throwable) {
        Class<?> clazz = throwable.getClass();
        ResponseStatus status = clazz.getAnnotation(ResponseStatus.class);
        logger.error(throwable.getMessage(), throwable);
        if (status != null && !status.value().equals((Object)HttpStatus.INTERNAL_SERVER_ERROR)) {
            int statusCode = status.value().value();
            if (HttpStatus.NOT_FOUND.value() == statusCode) {
                statusCode = HttpStatus.INTERNAL_SERVER_ERROR.value();
            }
        }
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @Log(value="\u6570\u636e\u9a8c\u8bc1\u5f02\u5e38", type=LogType.EXCEPTION)
    public void warningException(ApplicationWarningException warningException) {
        logger.warn(warningException.getMessage(), (Throwable)warningException);
        ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, warningException.getMessage()));
    }
}

