/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.database.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.database.dialect.Dialect;
import net.sinodawn.framework.database.dialect.DialectRepository;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.exception.database.JdbcException;
import net.sinodawn.framework.utils.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public abstract class SqlHelper {
    public static final String QTY_COLUMN_NAME = "QTY_";
    private static final Pattern SQL_ENDING_ORDER_BY_PATTERN = Pattern.compile("\\s+(?i)order\\s+(?i)by\\s+([^()]*[(][^()]*[)][^()]*)*[^()]*$");
    private static final Pattern SQL_ORDER_BY_PATTERN = Pattern.compile("(?i)order\\s+by");

    public static String removeEndingOrderIfPresent(String sql) {
        if (StringUtils.isEmpty(sql)) {
            return sql;
        }
        Matcher matcher = SQL_ENDING_ORDER_BY_PATTERN.matcher(sql);
        return matcher.find() ? matcher.replaceFirst("") : sql;
    }

    public static boolean hasOrderSegment(String sql) {
        Objects.requireNonNull(sql);
        Matcher matcher = SQL_ENDING_ORDER_BY_PATTERN.matcher(sql);
        return matcher.find();
    }

    public static String getOrderSegment(String sql) {
        Objects.requireNonNull(sql);
        Matcher matcher = SQL_ENDING_ORDER_BY_PATTERN.matcher(sql);
        if (matcher.find()) {
            int pos = matcher.start();
            String orderBySql = sql.substring(pos).trim();
            return SQL_ORDER_BY_PATTERN.matcher(orderBySql).replaceFirst("").trim();
        }
        throw new UnexpectedException("Not an ordered sql.");
    }

    public static String getSelectTotalSql(String sql, String[] sumProperties, String[] countProperties) {
        Dialect dialect = DialectRepository.getDialect();
        StringBuilder newSql = new StringBuilder("SELECT COUNT(1) ").append(QTY_COLUMN_NAME);
        if (sumProperties.length > 0) {
            Arrays.asList(sumProperties).forEach(c -> newSql.append(", SUM(").append(dialect.getNullReplacementClause(c.toUpperCase(), "0")).append(") ").append(c.toUpperCase()));
        }
        if (countProperties.length > 0) {
            Arrays.asList(countProperties).forEach(c -> newSql.append(", COUNT(DISTINCT ").append(c.toUpperCase()).append(") ").append(c.toUpperCase()));
        }
        newSql.append(" FROM (\n").append(SqlHelper.removeEndingOrderIfPresent(sql)).append("\n").append(") T");
        return newSql.toString();
    }

    public static boolean isRiskySqlSegment(String sqlSegment) {
        if (StringUtils.isEmpty(sqlSegment)) {
            return false;
        }
        return StringUtils.contains(sqlSegment, "'") || StringUtils.contains(sqlSegment, " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSqlColumnList(String sql) {
        ArrayList<String> columnList = new ArrayList<String>();
        SqlSessionTemplate template = ApplicationContextHelper.getMybatisSqlSessionTemplate();
        SqlSession sqlSession = null;
        try {
            sqlSession = SqlSessionUtils.getSqlSession((SqlSessionFactory)template.getSqlSessionFactory(), (ExecutorType)template.getExecutorType(), (PersistenceExceptionTranslator)template.getPersistenceExceptionTranslator());
            try (Statement stmt = sqlSession.getConnection().createStatement();
                 ResultSet rs = stmt.executeQuery(DialectRepository.getDialect().getLimitSql(sql, 0, 0));){
                ResultSetMetaData rsmd = rs.getMetaData();
                int j = rsmd.getColumnCount();
                for (int i = 0; i < j; ++i) {
                    columnList.add(rsmd.getColumnName(i + 1).toUpperCase());
                }
            }
            catch (SQLException var51) {
                throw new JdbcException(var51);
            }
        }
        finally {
            if (sqlSession != null) {
                SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)template.getSqlSessionFactory());
            }
        }
        return columnList;
    }
}

