/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.database.dialect;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import net.sinodawn.framework.database.context.ColumnContext;
import net.sinodawn.framework.database.dialect.ColumnMetadata;
import net.sinodawn.framework.database.dialect.Dialect;
import net.sinodawn.framework.exception.UnsupportedDataTypeJdbcException;

public class MysqlDialect
implements Dialect {
    @Override
    public String getDatabase() {
        return "mysql";
    }

    @Override
    public String getSelectFromTableSql(String sql) {
        return "SELECT * FROM " + sql;
    }

    @Override
    public String getLimitSql(String sql, int offset, int limit) {
        return limit == 0 ? "SELECT * FROM (\n" + sql + "\n) S_ LIMIT 0" : "SELECT * FROM ( SELECT S_.* FROM (\n" + sql + "\n) S_ LIMIT " + offset + "," + limit + ") R_";
    }

    @Override
    public Class<?> getJavaType(String columnName, String dataType, int scale) {
        switch (dataType.toLowerCase()) {
            case "varchar": 
            case "text": 
            case "mediumtext": 
            case "longtext": 
            case "blob": 
            case "longblob": 
            case "char": {
                return String.class;
            }
            case "int": 
            case "tinyint": 
            case "smallint": 
            case "bigint": 
            case "bigint unsigned": {
                return Long.class;
            }
            case "float": 
            case "double": {
                return Double.class;
            }
            case "decimal": {
                if (scale > 0) {
                    return Double.class;
                }
                return Long.class;
            }
            case "date": {
                return LocalDate.class;
            }
            case "datetime": 
            case "timestamp": {
                return LocalDateTime.class;
            }
        }
        throw new UnsupportedDataTypeJdbcException(columnName + "@" + dataType + "@" + scale);
    }

    @Override
    public boolean isClob(ColumnContext columnContext) {
        switch (columnContext.getDataType().toLowerCase()) {
            case "text": 
            case "mediumtext": 
            case "longtext": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBlob(ColumnContext columnContext) {
        switch (columnContext.getDataType().toLowerCase()) {
            case "blob": 
            case "longblob": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getNullReplacementClause(String column, String valueOrColumn) {
        return "IFNULL( " + column + ", " + valueOrColumn + ")";
    }

    @Override
    public String getConcatClause(String ... columnOrValues) {
        return null;
    }

    @Override
    public String getSelectFirstSql(String sql) {
        return "SELECT * FROM (\n" + sql + ") R_ LIMIT 1";
    }

    @Override
    public String getSelectTodoSql(String todoSql) {
        return "SELECT T.MENUID, T.MODELNAME, T.HREF, COUNT(1) QTY\n  FROM (" + todoSql + ") T\n GROUP BY T.MENUID, T.MODELNAME, T.HREF";
    }

    @Override
    public int getInClauseIdMaxQty() {
        return 10000;
    }

    @Override
    public int getMaxParamQty() {
        return 1000000;
    }

    @Override
    public List<String> getAddColumnSqlList(String tableName, ColumnMetadata columnMetadata) {
        return null;
    }

    @Override
    public String getDropColumnSql(String tableName, String columnName) {
        return null;
    }
}

