/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.database.dialect;

import java.util.List;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.database.dialect.Dialect;
import net.sinodawn.framework.database.dialect.MysqlDialect;
import net.sinodawn.framework.utils.ClassUtils;

public class DialectRepository {
    private static Dialect dialect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Dialect getDialect() {
        if (dialect != null) return dialect;
        Class<DialectRepository> clazz = DialectRepository.class;
        synchronized (DialectRepository.class) {
            if (dialect != null) return dialect;
            List<Class<?>> dialectClassList = ClassUtils.getPredicatedClasses("net.sinodawn", c -> !c.isInterface() && Dialect.class.isAssignableFrom((Class<?>)c));
            for (Class<?> aClass : dialectClassList) {
                Class<?> dialectClass = aClass;
                Dialect dialect = (Dialect)ClassUtils.newInstance(dialectClass);
                if (!ApplicationContextHelper.isProfileActivated(dialect.getDatabase())) continue;
                DialectRepository.dialect = dialect;
                break;
            }
            if (dialect != null) return dialect;
            dialect = new MysqlDialect();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dialect;
        }
    }
}

