/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.database.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.cache.redis.RedisHelper;
import net.sinodawn.framework.database.context.ColumnContext;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.context.TableContext;
import net.sinodawn.framework.database.context.instance.EntityHelper;
import net.sinodawn.framework.database.dialect.DialectRepository;
import net.sinodawn.framework.exception.database.JdbcException;
import net.sinodawn.framework.mybatis.MybatisHelper;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class DatabaseManager {
    public static final String TABLE_CONTEXT_CACHE_NAME = "TableContext";
    public static final String ENTITY_CONTEXT_CACHE_NAME = "EntityContext";

    public static TableContext getTableContext(String tableName) {
        TableContext tableContext = (TableContext)RedisHelper.get(TABLE_CONTEXT_CACHE_NAME, tableName = tableName.toUpperCase());
        if (tableContext == null) {
            tableContext = new TableContext();
            tableContext.setTableName(tableName);
            tableContext.setColumnContextList(DatabaseManager.selectColumnContextList(DialectRepository.getDialect().getSelectFromTableSql(tableName)));
            RedisHelper.put(TABLE_CONTEXT_CACHE_NAME, tableName, tableContext);
        }
        return tableContext;
    }

    public static List<ColumnContext> getTableColumnContextList(String tableName) {
        tableName = tableName.toUpperCase();
        return DatabaseManager.getTableContext(tableName).getColumnContextList();
    }

    public static EntityContext getEntityContext(Class<? extends Persistable<?>> entityClass) {
        String cacheKey = ClassUtils.getRawType(entityClass).toString();
        String tableName = PersistableMetadataHelper.getTableName(entityClass);
        EntityContext entityContext = (EntityContext)RedisHelper.get(ENTITY_CONTEXT_CACHE_NAME, cacheKey);
        if (entityContext == null) {
            entityContext = new EntityContext();
            entityContext.setTableName(tableName);
            TableContext tableContext = DatabaseManager.getTableContext(tableName);
            List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(entityClass);
            ArrayList<EntityColumnContext> columnContextList = new ArrayList<EntityColumnContext>();
            for (ColumnContext columnContext : tableContext.getColumnContextList()) {
                BeanPropertyDescriptor propertyDescriptor = propertyDescriptorList.stream().filter(p -> columnContext.getColumnName().equalsIgnoreCase(p.getName())).findFirst().orElse(null);
                EntityColumnContext entityColumnContext = new EntityColumnContext();
                entityColumnContext.setEntityClass(entityClass);
                entityColumnContext.setColumnName(columnContext.getColumnName());
                entityColumnContext.setBlob(DialectRepository.getDialect().isBlob(columnContext));
                entityColumnContext.setClob(DialectRepository.getDialect().isClob(columnContext));
                if (propertyDescriptor == null) {
                    entityColumnContext.setType(columnContext.getType());
                } else {
                    entityColumnContext.setType(propertyDescriptor.getPropertyType());
                }
                if ("id".equalsIgnoreCase(columnContext.getColumnName())) {
                    entityContext.setIdContext(entityColumnContext);
                } else if ("version".equalsIgnoreCase(columnContext.getColumnName())) {
                    entityContext.setVersionContext(entityColumnContext);
                }
                columnContextList.add(entityColumnContext);
            }
            EntityHelper.sortColumnContext(columnContextList);
            entityContext.setColumnContextList(columnContextList);
            RedisHelper.put(ENTITY_CONTEXT_CACHE_NAME, cacheKey, entityContext);
        }
        return entityContext;
    }

    public static List<ColumnContext> selectColumnContextList(String sql) {
        ArrayList<ColumnContext> arrayList;
        String selectEmptySql = DialectRepository.getDialect().getLimitSql(sql, 0, 0);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = MybatisHelper.getConnection();
            ps = conn.prepareStatement(selectEmptySql);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            ArrayList<ColumnContext> columnContextList = new ArrayList<ColumnContext>();
            for (int i = 1; i <= qty; ++i) {
                ColumnContext columnContext = new ColumnContext();
                columnContext.setRawColumnName(rsmd.getColumnName(i));
                columnContext.setColumnName(StringUtils.upperCase(columnContext.getRawColumnName()));
                columnContext.setDataType(rsmd.getColumnTypeName(i));
                int scale = rsmd.getScale(i);
                columnContext.setType(DialectRepository.getDialect().getJavaType(columnContext.getColumnName(), columnContext.getDataType(), scale));
                columnContextList.add(columnContext);
            }
            arrayList = columnContextList;
        }
        catch (SQLException var14) {
            try {
                throw new JdbcException(var14);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement((Statement)ps);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)ps);
        JdbcUtils.closeConnection((Connection)conn);
        return arrayList;
    }
}

