/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.database.context.instance;

import java.time.LocalDateTime;
import java.util.List;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyListener;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.context.instance.EntityColumnContextInstance;
import net.sinodawn.framework.database.context.instance.EntityContextInstance;
import net.sinodawn.framework.database.core.DatabaseManager;
import net.sinodawn.framework.support.domain.Insertable;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.StringUtils;

public abstract class EntityHelper {
    private static final String[] CREATED_BY_COLUMNS = new String[]{"createdById", "createdByName", "createdByOrgId", "createdByOrgName", "createdTime"};

    public static boolean isColumnActivated(Persistable<?> item, EntityColumnContext columnContext) {
        BeanPropertyDescriptor propertyDescriptor = columnContext.getPropertyDescriptor();
        if (BeanPropertyListener.class.isAssignableFrom(item.getClass())) {
            return propertyDescriptor.isExt$BeanProperty() ? ((BeanPropertyListener)((Object)item)).getChangedPropertyEventList().stream().anyMatch(e -> columnContext.getColumnName().equalsIgnoreCase(e.getName())) : ((BeanPropertyListener)((Object)item)).getChangedPropertyEventList().stream().anyMatch(e -> e.getPropertyDescriptor().equals(propertyDescriptor));
        }
        if (propertyDescriptor.isExt$BeanProperty()) {
            return item.getExt$().containsKey(columnContext.getColumnName());
        }
        return columnContext.getValue(item) != null;
    }

    public static void sortColumnContextInstance(List<EntityColumnContextInstance> columnContextInstanceList) {
        columnContextInstanceList.sort((c1, c2) -> {
            if (EntityHelper.isIdInstance(c1)) {
                return -1;
            }
            return EntityHelper.isIdInstance(c2) ? 1 : c1.getColumnContext().getColumnName().compareToIgnoreCase(c2.getColumnContext().getColumnName());
        });
    }

    public static void sortColumnContext(List<EntityColumnContext> columnContextList) {
        columnContextList.sort((c1, c2) -> {
            if (EntityHelper.isIdContext(c1)) {
                return -1;
            }
            return EntityHelper.isIdContext(c2) ? 1 : c1.getColumnName().compareToIgnoreCase(c2.getColumnName());
        });
    }

    public static boolean isIdColumn(String column) {
        return "id".equalsIgnoreCase(column);
    }

    public static boolean isCreatedByColumn(String column) {
        return ArrayUtils.containsIgnoreCase(CREATED_BY_COLUMNS, column);
    }

    public static boolean isIdInstance(EntityColumnContextInstance columnContextInstance) {
        return EntityHelper.isIdColumn(columnContextInstance.getColumnContext().getColumnName());
    }

    public static boolean isIdContext(EntityColumnContext columnContext) {
        return EntityHelper.isIdColumn(columnContext.getColumnName());
    }

    public static boolean isColumnUpdatable(String column) {
        return !EntityHelper.isIdColumn(column) && !ArrayUtils.containsIgnoreCase(CREATED_BY_COLUMNS, column);
    }

    public static boolean isColumnUpdatable(EntityColumnContext columnContext) {
        return EntityHelper.isColumnUpdatable(columnContext.getColumnName());
    }

    public static boolean isColumnUpdatable(EntityColumnContextInstance columnContextInstance) {
        return EntityHelper.isColumnUpdatable(columnContextInstance.getColumnContext().getColumnName());
    }

    public static boolean isColumnUpdated(EntityContextInstance contextInstance) {
        return contextInstance.getColumnContextInstanceList().stream().anyMatch(c -> c.isActive() && EntityHelper.isColumnUpdatable(c));
    }

    public static void assignCreatedElement(Insertable<?> item) {
        item.setCreatedById(LocalContextHelper.getLoginUserId());
        item.setCreatedByName(LocalContextHelper.getLoginUserName());
        item.setCreatedByOrgId(LocalContextHelper.getLoginOrgId());
        item.setCreatedByOrgName(LocalContextHelper.getLoginOrgName());
        item.setCreatedTime(LocalDateTime.now());
    }

    public static void assignCreatedElementIfNecessary(Insertable<?> item) {
        if (StringUtils.isEmpty(item.getCreatedById())) {
            item.setCreatedById(LocalContextHelper.getLoginUserId());
        }
        if (StringUtils.isEmpty(item.getCreatedByName())) {
            item.setCreatedByName(LocalContextHelper.getLoginUserName());
        }
        if (StringUtils.isEmpty(item.getCreatedByOrgId())) {
            item.setCreatedByOrgId(LocalContextHelper.getLoginOrgId());
        }
        if (StringUtils.isEmpty(item.getCreatedByOrgName())) {
            item.setCreatedByOrgName(LocalContextHelper.getLoginOrgName());
        }
        if (item.getCreatedTime() == null) {
            item.setCreatedTime(LocalDateTime.now());
        }
    }

    public static boolean isItemUpdated(Persistable<?> item) {
        if (item == null) {
            return false;
        }
        EntityContext context = DatabaseManager.getEntityContext(item.getClass());
        return context.getColumnContextList().stream().filter(EntityHelper::isColumnUpdatable).anyMatch(c -> EntityHelper.isColumnActivated(item, c));
    }
}

