/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.database.context.instance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.context.instance.EntityColumnContextInstance;
import net.sinodawn.framework.database.context.instance.EntityHelper;
import net.sinodawn.framework.database.core.DatabaseManager;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ClassUtils;

public class EntityContextInstance
implements Serializable {
    private static final long serialVersionUID = 2036905136662907022L;
    private EntityContext context;
    private EntityColumnContextInstance idInstance;
    private List<EntityColumnContextInstance> columnContextInstanceList;

    private EntityContextInstance() {
    }

    public static <T extends Persistable<?>> EntityContextInstance updatable(T item, String ... activeColumns) {
        return EntityContextInstance.of(item, EntityContextInstanceCategory.UPDATABLE, activeColumns);
    }

    public static <T extends Persistable<?>> EntityContextInstance insertable(T item, String ... activeColumns) {
        return EntityContextInstance.of(item, EntityContextInstanceCategory.INSERTABLE, activeColumns);
    }

    public static <T extends Persistable<?>> EntityContextInstance instance(T item, String ... activeColumns) {
        return EntityContextInstance.of(item, EntityContextInstanceCategory.DEFAULT, activeColumns);
    }

    private static <T extends Persistable<?>> EntityContextInstance of(T item, EntityContextInstanceCategory category, String ... activeColumns) {
        EntityContextInstance instance = new EntityContextInstance();
        instance.context = DatabaseManager.getEntityContext(ClassUtils.getRawType(item.getClass()));
        instance.columnContextInstanceList = new ArrayList<EntityColumnContextInstance>();
        boolean isEmpty = BeanUtils.isEmpty(item);
        instance.context.getColumnContextList().forEach(c -> {
            EntityColumnContextInstance columnContextInstance = EntityColumnContextInstance.of(c, item);
            if (ArrayUtils.isEmpty(activeColumns)) {
                if (category.equals((Object)EntityContextInstanceCategory.UPDATABLE)) {
                    columnContextInstance.setActive(EntityHelper.isColumnActivated(item, c) && EntityHelper.isColumnUpdatable(c));
                } else {
                    columnContextInstance.setActive(EntityHelper.isColumnActivated(item, c));
                }
            } else {
                columnContextInstance.setActive(ArrayUtils.containsIgnoreCase(activeColumns, c.getColumnName()));
            }
            if (EntityHelper.isIdInstance(columnContextInstance)) {
                instance.idInstance = columnContextInstance;
            }
            if (category.equals((Object)EntityContextInstanceCategory.INSERTABLE)) {
                instance.columnContextInstanceList.add(columnContextInstance);
            } else if (columnContextInstance.isValueAssigned()) {
                instance.columnContextInstanceList.add(columnContextInstance);
            } else if (isEmpty) {
                instance.columnContextInstanceList.add(columnContextInstance);
            }
        });
        EntityHelper.sortColumnContextInstance(instance.columnContextInstanceList);
        return instance;
    }

    public EntityContext getContext() {
        return this.context;
    }

    public EntityColumnContextInstance getIdInstance() {
        return this.idInstance;
    }

    public List<EntityColumnContextInstance> getColumnContextInstanceList() {
        return this.columnContextInstanceList;
    }

    private static enum EntityContextInstanceCategory {
        UPDATABLE,
        INSERTABLE,
        DEFAULT;

    }
}

