/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.utils.StringUtils;

public enum StringToEnumConverterFactory implements ConverterFactory<String, Enum>
{
    INSTANCE;


    @Override
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToEnumConverter<T>(targetType);
    }

    private class StringToEnumConverter<T extends Enum>
    implements Converter<String, T> {
        private final Class<T> enumType;

        public StringToEnumConverter(Class<T> enumType) {
            this.enumType = enumType;
        }

        @Override
        public Class<String> getSourceType() {
            return String.class;
        }

        @Override
        public Class<T> getTargetType() {
            return this.enumType;
        }

        @Override
        public T convert(String source) {
            return StringUtils.isEmpty(source) ? null : (T)Enum.valueOf(this.enumType, source.trim());
        }
    }
}

