/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.converter.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.converter.exception.ConverterNotFoundException;

public enum NumberToNumberConverterFactory implements ConverterFactory<Number, Number>
{
    INSTANCE;


    @Override
    public <T extends Number> Converter<Number, T> getConverter(Class<T> targetType) {
        return new NumberToNumberConverter<T>(targetType);
    }

    private static class NumberToNumberConverter<T extends Number>
    implements Converter<Number, T> {
        private final Class<T> numberType;

        public NumberToNumberConverter(Class<T> numberType) {
            this.numberType = numberType;
        }

        @Override
        public Class<Number> getSourceType() {
            return Number.class;
        }

        @Override
        public Class<T> getTargetType() {
            return this.numberType;
        }

        @Override
        public T convert(Number source) {
            if (source == null) {
                return null;
            }
            Class<T> targetType = this.getTargetType();
            if (Byte.class != targetType && Byte.TYPE != targetType) {
                if (Short.class != targetType && Short.TYPE != targetType) {
                    if (Integer.class != targetType && Integer.TYPE != targetType) {
                        if (Long.class != targetType && Long.TYPE != targetType) {
                            if (Float.class != targetType && Float.TYPE != targetType) {
                                if (Double.class != targetType && Double.TYPE != targetType) {
                                    if (BigInteger.class == targetType) {
                                        return (T)BigInteger.valueOf(source.longValue());
                                    }
                                    if (BigDecimal.class == targetType) {
                                        return (T)BigDecimal.valueOf(source.doubleValue());
                                    }
                                    throw new ConverterNotFoundException(this.getSourceType(), targetType);
                                }
                                return (T)Double.valueOf(source.doubleValue());
                            }
                            return (T)Float.valueOf(source.floatValue());
                        }
                        return (T)Long.valueOf(source.longValue());
                    }
                    return (T)Integer.valueOf(source.intValue());
                }
                return (T)Short.valueOf(source.shortValue());
            }
            return (T)Byte.valueOf(source.byteValue());
        }
    }
}

