/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.converter.date;

import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConverterNotFoundException;
import net.sinodawn.framework.utils.DateTimeUtils;

public interface JSR310ToStringGenericConverter<S extends Temporal>
extends Converter<S, String> {
    @Override
    default public Class<S> getSourceType() {
        return (Class)((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    @Override
    default public Class<String> getTargetType() {
        return String.class;
    }

    @Override
    default public String convert(S source) {
        if (source == null) {
            return null;
        }
        Class<S> sourceType = this.getSourceType();
        if (LocalDateTime.class.equals(sourceType)) {
            return DateTimeUtils.formatLocalDateTime((LocalDateTime)source);
        }
        if (LocalDate.class.equals(sourceType)) {
            return DateTimeUtils.formatLocalDate((LocalDate)source);
        }
        if (LocalTime.class.equals(sourceType)) {
            return DateTimeUtils.formatLocalTime((LocalTime)source);
        }
        throw new ConverterNotFoundException(sourceType, this.getTargetType());
    }

    public static enum LocalDateTimeToStringConverter implements JSR310ToStringGenericConverter<LocalDateTime>
    {
        INSTANCE;

    }

    public static enum LocalDateToStringConverter implements JSR310ToStringGenericConverter<LocalDate>
    {
        INSTANCE;

    }

    public static enum LocalTimeToStringConverter implements JSR310ToStringGenericConverter<LocalTime>
    {
        INSTANCE;

    }
}

