/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.converter.date;

import java.lang.reflect.ParameterizedType;
import java.sql.Time;
import java.util.Date;
import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.utils.DateTimeUtils;

public interface DateToStringConverterFactory<S extends Date>
extends Converter<S, String> {
    @Override
    default public Class<S> getSourceType() {
        return (Class)((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    @Override
    default public Class<String> getTargetType() {
        return String.class;
    }

    @Override
    default public String convert(S source) {
        Class<S> sourceType = this.getSourceType();
        return Time.class.equals(sourceType) ? DateTimeUtils.formatTime(source) : DateTimeUtils.formatDateTime(source);
    }

    public static enum DateToStringConverter implements DateToStringConverterFactory<Date>
    {
        INSTANCE;

    }

    public static enum TimeToStringConverter implements DateToStringConverterFactory<Time>
    {
        INSTANCE;

    }
}

