/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.converter.bool;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.utils.NumberUtils;

public enum BooleanToNumberConverterFactory implements ConverterFactory<Boolean, Number>
{
    INSTANCE;


    @Override
    public <T extends Number> Converter<Boolean, T> getConverter(Class<T> targetType) {
        return new BooleanToNumberConverter<T>(targetType);
    }

    private class BooleanToNumberConverter<T extends Number>
    implements Converter<Boolean, T> {
        private final Class<T> numberType;

        public BooleanToNumberConverter(Class<T> numberType) {
            this.numberType = numberType;
        }

        @Override
        public Class<Boolean> getSourceType() {
            return Boolean.class;
        }

        @Override
        public Class<T> getTargetType() {
            return this.numberType;
        }

        @Override
        public T convert(Boolean source) {
            if (source == null) {
                return null;
            }
            return Boolean.TRUE.equals(source) ? NumberUtils.parseNumber("1", this.getTargetType()) : NumberUtils.parseNumber("0", this.getTargetType());
        }
    }
}

