/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.converter;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import net.sinodawn.framework.converter.exception.ConverterNotFoundException;

public interface Convertable<S, T> {
    default public Class<S> getSourceType() {
        return (Class)((ParameterizedType)Arrays.stream(this.getClass().getGenericInterfaces()).findFirst().orElseThrow(ConverterNotFoundException::new)).getActualTypeArguments()[0];
    }

    default public Class<T> getTargetType() {
        return (Class)((ParameterizedType)Arrays.stream(this.getClass().getGenericInterfaces()).findFirst().orElseThrow(ConverterNotFoundException::new)).getActualTypeArguments()[1];
    }

    default public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.getSourceType().isAssignableFrom(sourceType) && this.getTargetType().isAssignableFrom(targetType);
    }
}

