/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.context.concurrent;

import net.sinodawn.framework.cache.redis.RedisHelper;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.exception.ConcurrentException;
import net.sinodawn.framework.i18n.I18nHelper;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SinoConcurrentLocker {
    public static final String LOCKER_ISOLATED_CACHE_NAME = "SINO_ISOLATED_CONCURRENT";
    public static final String LOCKER_BLOCK_CACHE_NAME = "SINO_BLOCK_CONCURRENT";
    public static final int DEFAULT_EXPIRE_SECONDS = 300;

    public static void isolated(final String key) {
        String cacheValue = SinoConcurrentLocker.getCacheValue();
        if (!RedisHelper.putIfAbsent(LOCKER_ISOLATED_CACHE_NAME, key, cacheValue, 300)) {
            if (!cacheValue.equals(RedisHelper.get(LOCKER_ISOLATED_CACHE_NAME, key))) {
                throw new ConcurrentException(I18nHelper.getMessage("SINO.CONCURRENT.ISOLATED", new String[0]));
            }
        } else {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    SinoConcurrentLocker.releaseLock(SinoConcurrentLocker.LOCKER_ISOLATED_CACHE_NAME, key);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void isolatedRun(String key, Runnable runnable) {
        boolean lock = false;
        try {
            String cacheValue = SinoConcurrentLocker.getCacheValue();
            if (!RedisHelper.putIfAbsent(LOCKER_ISOLATED_CACHE_NAME, key, cacheValue, 300) && !cacheValue.equals(RedisHelper.get(LOCKER_ISOLATED_CACHE_NAME, key))) {
                return;
            }
            lock = true;
            runnable.run();
        }
        finally {
            if (lock) {
                SinoConcurrentLocker.releaseLock(LOCKER_ISOLATED_CACHE_NAME, key);
            }
        }
    }

    public static void block(final String key) {
        boolean block = true;
        String cacheValue = SinoConcurrentLocker.getCacheValue();
        while (!RedisHelper.putIfAbsent(LOCKER_BLOCK_CACHE_NAME, key, cacheValue, 300)) {
            if (cacheValue.equals(RedisHelper.get(LOCKER_BLOCK_CACHE_NAME, key))) {
                block = false;
                break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (block) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    SinoConcurrentLocker.releaseLock(SinoConcurrentLocker.LOCKER_BLOCK_CACHE_NAME, key);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockRun(String key, int timeoutSeconds, Runnable runnable) {
        boolean block = true;
        try {
            if (timeoutSeconds <= 0) {
                timeoutSeconds = 300;
            }
            String cacheValue = SinoConcurrentLocker.getCacheValue();
            while (!RedisHelper.putIfAbsent(LOCKER_BLOCK_CACHE_NAME, key, cacheValue, timeoutSeconds)) {
                if (!cacheValue.equals(RedisHelper.get(LOCKER_BLOCK_CACHE_NAME, key))) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                block = false;
                break;
            }
            runnable.run();
            return;
        }
        finally {
            if (block) {
                SinoConcurrentLocker.releaseLock(LOCKER_BLOCK_CACHE_NAME, key);
            }
        }
    }

    public static void blockRun(String key, Runnable runnable) {
        SinoConcurrentLocker.blockRun(key, 0, runnable);
    }

    public static void releaseLock(String name, String key) {
        try {
            RedisHelper.evict(name, key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getCacheValue() {
        return ApplicationContextHelper.getAppId() + Thread.currentThread().getId();
    }
}

