/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.CaseInsensitiveLinkedMap;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;

public class SinoBeanContext {
    private final Map<String, GenericService<?, ?>> TABLE_AWARE_SERVICE_CONTAINER = new CaseInsensitiveLinkedMap();
    private final Map<String, GenericService<?, ?>> RESTFULAPI_AWARE_SERVICE_CONTAINER = new CaseInsensitiveLinkedMap();
    private static SinoBeanContext context;

    private SinoBeanContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (context != null) return;
        Class<SinoBeanContext> var0 = SinoBeanContext.class;
        Class<SinoBeanContext> clazz = SinoBeanContext.class;
        synchronized (SinoBeanContext.class) {
            if (context != null) return;
            context = new SinoBeanContext();
            context.extranct(Repository.class);
            context.extranct(Service.class);
            context.extranct(Component.class);
            context.extranct(RequestMapping.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static <T extends GenericService<?, ?>> T getServiceByTable(String table) {
        return (T)(context != null ? SinoBeanContext.context.TABLE_AWARE_SERVICE_CONTAINER.get(table) : null);
    }

    public static <T extends GenericService<?, ?>> T getServiceByRESTfulAPI(String restAPI) {
        return (T)(context != null ? SinoBeanContext.context.RESTFULAPI_AWARE_SERVICE_CONTAINER.get(restAPI) : null);
    }

    private void extranct(Class<? extends Annotation> annotationType) {
        ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
        Map map = applicationContext.getBeansWithAnnotation(annotationType);
        map.forEach((k, v) -> {
            block5: {
                Class<?> clazz;
                block4: {
                    String table;
                    GenericService service;
                    block6: {
                        clazz = ClassUtils.getRawType(v.getClass());
                        if (!GenericService.class.isAssignableFrom(clazz)) break block4;
                        service = (GenericService)v;
                        if (service.getDao() == null) {
                            return;
                        }
                        table = service.getDao().getTable();
                        if (StringUtils.isEmpty(table)) break block5;
                        if (this.TABLE_AWARE_SERVICE_CONTAINER.containsKey(table)) break block6;
                        this.TABLE_AWARE_SERVICE_CONTAINER.put(table, service);
                        break block5;
                    }
                    GenericService<?, ?> oldService = this.TABLE_AWARE_SERVICE_CONTAINER.get(table);
                    Class<?> oldClazzx = ClassUtils.getRawType(oldService.getClass());
                    if (!clazz.isAssignableFrom(oldClazzx)) break block5;
                    this.TABLE_AWARE_SERVICE_CONTAINER.put(table, service);
                    break block5;
                }
                if (GenericResource.class.isAssignableFrom(clazz)) {
                    RequestMapping requestMapping = ReflectionUtils.getAnnotation(clazz, RequestMapping.class);
                    GenericResource resource = (GenericResource)v;
                    if (requestMapping != null) {
                        for (String value : requestMapping.value()) {
                            this.RESTFULAPI_AWARE_SERVICE_CONTAINER.put(value, (GenericService<?, ?>)resource.getService());
                        }
                    }
                }
            }
        });
    }
}

