/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sinodawn.framework.context.SinoBeanContext;
import net.sinodawn.framework.exception.NotUniqueException;
import net.sinodawn.framework.id.SinoIdHelper;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.module.sys.constant.bean.CoreConstantBean;
import net.sinodawn.module.sys.constant.service.CoreConstantService;
import net.sinodawn.module.sys.metadata.bean.CoreParentTableInstanceDTO;
import net.sinodawn.module.sys.metadata.service.CoreTableService;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ApplicationContextHelper
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static CoreConstantService constantService;
    private static CoreTableService tableService;
    private static SqlSessionTemplate sqlSessionTemplate;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHelper.applicationContext = applicationContext;
    }

    public static String getAppId() {
        return "439324902109242";
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Environment getEnvironment() {
        return ApplicationContextHelper.getApplicationContext().getEnvironment();
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)ApplicationContextHelper.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name) {
        Class sinoClass = ClassUtils.getSinoClass(name);
        if (sinoClass == null) {
            return null;
        }
        Collection collection = ApplicationContextHelper.getApplicationContext().getBeansOfType(sinoClass).values();
        if (collection.size() > 1) {
            throw new NotUniqueException(name);
        }
        return collection.isEmpty() ? null : (T)collection.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlSessionTemplate getMybatisSqlSessionTemplate() {
        if (sqlSessionTemplate != null) return sqlSessionTemplate;
        Class<ApplicationContextHelper> var0 = ApplicationContextHelper.class;
        Class<ApplicationContextHelper> clazz = ApplicationContextHelper.class;
        synchronized (ApplicationContextHelper.class) {
            if (sqlSessionTemplate != null) return sqlSessionTemplate;
            sqlSessionTemplate = (SqlSessionTemplate)ApplicationContextHelper.getApplicationContext().getBean(SqlSessionTemplate.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sqlSessionTemplate;
        }
    }

    public static <T> T getBeanIfPresent(String name) {
        return ApplicationContextHelper.getApplicationContext().containsBean(name) ? (T)ApplicationContextHelper.getBean(name) : null;
    }

    public static Long getNextIdentity() {
        return SinoIdHelper.nextId();
    }

    public static List<Long> getNextIdentityList(int qty) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (int i = 0; i < qty; ++i) {
            idList.add(SinoIdHelper.nextId());
        }
        return idList;
    }

    public static List<Long> getNextOrderNoList(int qty) {
        return ApplicationContextHelper.getNextIdentityList(qty);
    }

    public static Long getNextOrderNo() {
        return ApplicationContextHelper.getNextIdentity();
    }

    public static <T extends GenericService<?, ?>> T getServiceByTable(String table) {
        return SinoBeanContext.getServiceByTable(table);
    }

    public static boolean isProfileActivated(String profile) {
        return ArrayUtils.contains(ApplicationContextHelper.getApplicationContext().getEnvironment().getActiveProfiles(), profile);
    }

    public static String getConstantValue(String id) {
        return ApplicationContextHelper.getConstantValue(id, "");
    }

    public static String getConstantValue(String id, String defaultValue) {
        CoreConstantBean constant = (CoreConstantBean)ApplicationContextHelper.getCoreConstantService().selectByIdIfPresent(id);
        return constant == null ? defaultValue : constant.getConstantValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <ID extends Serializable> List<CoreParentTableInstanceDTO> getAncientTableInstanceList(String table, List<ID> idList) {
        if (tableService != null) return tableService.selectAncientTableInstanceList(table, idList);
        Class<ApplicationContextHelper> var2 = ApplicationContextHelper.class;
        Class<ApplicationContextHelper> clazz = ApplicationContextHelper.class;
        synchronized (ApplicationContextHelper.class) {
            if (tableService != null) return tableService.selectAncientTableInstanceList(table, idList);
            tableService = (CoreTableService)ApplicationContextHelper.getApplicationContext().getBean(CoreTableService.class);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return tableService.selectAncientTableInstanceList(table, idList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CoreConstantService getCoreConstantService() {
        if (constantService != null) return constantService;
        Class<ApplicationContextHelper> var0 = ApplicationContextHelper.class;
        Class<ApplicationContextHelper> clazz = ApplicationContextHelper.class;
        synchronized (ApplicationContextHelper.class) {
            if (constantService != null) return constantService;
            constantService = (CoreConstantService)ApplicationContextHelper.getApplicationContext().getBean(CoreConstantService.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return constantService;
        }
    }
}

