/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.cache.redis;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisHelper {
    private static final String KEY_LINK_STRS = "::";
    private static RedisTemplate redisTemplate;

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisHelper.redisTemplate = redisTemplate;
    }

    public static RedisTemplate<String, Object> getRedisTemplate() {
        if (redisTemplate == null) {
            redisTemplate = ApplicationContextHelper.getBean(RedisTemplate.class);
        }
        return redisTemplate;
    }

    public static <T> T get(String name, String key) {
        return (T)RedisHelper.getRedisTemplate().opsForValue().get((Object)RedisHelper.getRedisKey(name, key));
    }

    public static <T> void put(String name, String key, T value) {
        RedisHelper.getRedisTemplate().opsForValue().set((Object)RedisHelper.getRedisKey(name, key), value);
    }

    public static <T> boolean putIfAbsent(String name, String key, T value, int timeoutSeconds) {
        return !Boolean.FALSE.equals(RedisHelper.getRedisTemplate().opsForValue().setIfAbsent((Object)RedisHelper.getRedisKey(name, key), value, (long)timeoutSeconds, TimeUnit.SECONDS));
    }

    public static <T> void put(String name, String key, T value, int timeoutSeconds) {
        RedisHelper.getRedisTemplate().opsForValue().set((Object)RedisHelper.getRedisKey(name, key), value, (long)timeoutSeconds, TimeUnit.SECONDS);
    }

    public static void evict(String name, String key) {
        RedisHelper.getRedisTemplate().opsForValue().getOperations().delete((Object)RedisHelper.getRedisKey(name, key));
    }

    public static void evict(String name) {
        RedisOperations redisOperations = RedisHelper.getRedisTemplate().opsForValue().getOperations();
        redisOperations.delete((Collection)Objects.requireNonNull(redisOperations.keys((Object)(name + "::*"))));
    }

    public static void expire(String name, String key, int seconds) {
        RedisHelper.getRedisTemplate().opsForValue().getOperations().expire((Object)RedisHelper.getRedisKey(name, key), (long)seconds, TimeUnit.SECONDS);
    }

    private static String getRedisKey(String cacheName, String cacheKey) {
        return cacheName + KEY_LINK_STRS + cacheKey;
    }
}

