/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.beans.impl;

import java.beans.Transient;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyEvent;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.beans.BeanPropertyInterceptor;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.cglib.proxy.MethodProxy;

public class BeanPropertyInterceptorImpl<T>
implements BeanPropertyInterceptor<T> {
    private T bean;
    private final boolean nullPropertyUnassigned;
    protected List<BeanPropertyEvent> changedPropertyEventList = new ArrayList<BeanPropertyEvent>();
    private final List<BeanPropertyDescriptor> propertyDescriptorList = new ArrayList<BeanPropertyDescriptor>();

    public BeanPropertyInterceptorImpl(T bean, boolean nullPropertyUndefined) {
        this.bean = bean;
        this.nullPropertyUnassigned = nullPropertyUndefined;
        this.propertyDescriptorList.addAll(BeanPropertyHelper.getBeanPropertyDescriptorList(bean.getClass()));
    }

    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        String methodName = method.getName();
        if ("setExt$".equals(methodName)) {
            Map oldMap = Optional.of(((BaseData)this.getOriginalValue()).getExt$()).orElse(new HashMap());
            Map newMap = Optional.of((Map)args[0]).orElse(new HashMap());
            BeanPropertyDescriptor extPd = BeanPropertyDescriptor.of(this.bean.getClass(), "ext$");
            newMap.forEach((k, v) -> {
                String oldValue = (String)oldMap.get(k);
                if (!oldMap.containsKey(k) || !ObjectUtils.equals(oldValue, v)) {
                    BeanPropertyEvent event = new BeanPropertyEvent(target, extPd);
                    event.setName(k.toUpperCase());
                    event.setNewValue(v);
                    event.setOldValue(oldValue);
                    this.changedPropertyEventList.removeIf(e -> k.equalsIgnoreCase(e.getName()));
                    this.changedPropertyEventList.add(event);
                }
            });
            oldMap.forEach((k, v) -> {
                if (!newMap.containsKey(k)) {
                    BeanPropertyEvent event = new BeanPropertyEvent(target, extPd);
                    event.setName(k.toUpperCase());
                    event.setNewValue(null);
                    event.setOldValue(v);
                    this.changedPropertyEventList.removeIf(e -> k.equalsIgnoreCase(e.getName()));
                    this.changedPropertyEventList.add(event);
                }
            });
        } else if ("setExt$Item".equals(methodName)) {
            String name = ((String)args[0]).toUpperCase();
            String oldValue = ((BaseData)this.getOriginalValue()).getExt$().get(name);
            if (!((BaseData)this.getOriginalValue()).getExt$().containsKey(name) || !ObjectUtils.equals(args[1], oldValue)) {
                BeanPropertyEvent event = new BeanPropertyEvent(target, BeanPropertyDescriptor.of(this.bean.getClass(), "ext$"));
                event.setName(name);
                event.setNewValue(args[1]);
                event.setOldValue(oldValue);
                this.changedPropertyEventList.removeIf(e -> name.equalsIgnoreCase(e.getName()));
                this.changedPropertyEventList.add(event);
            }
        } else if (ReflectionUtils.isWriteMethod(method)) {
            Method readMethod;
            Object oldValue;
            String name = StringUtils.uncapitalize(method.getName().substring(3));
            BeanPropertyDescriptor propertyDescriptor = BeanPropertyDescriptor.of(this.bean.getClass(), name);
            if (propertyDescriptor != null && propertyDescriptor.isValidBeanProperty() && !propertyDescriptor.isAnnotationPresent(Transient.class) && this.isPropertyChanged(oldValue = ReflectionUtils.invokeMethod(readMethod = propertyDescriptor.getReadMethod(), this.getOriginalValue(), new Object[0]), args[0])) {
                BeanPropertyEvent event = new BeanPropertyEvent(target, propertyDescriptor);
                event.setNewValue(args[0]);
                event.setOldValue(oldValue);
                this.changedPropertyEventList.removeIf(e -> propertyDescriptor.equals(e.getPropertyDescriptor()));
                this.changedPropertyEventList.add(event);
            }
        }
        if ("getChangedPropertyEventList".equals(method.getName())) {
            return this.changedPropertyEventList;
        }
        if ("finalize".equals(method.getName())) {
            this.bean = null;
            this.changedPropertyEventList = null;
            return methodProxy.invokeSuper(target, args);
        }
        return ReflectionUtils.invokeMethod(method, this.getOriginalValue(), args);
    }

    @Override
    public T getOriginalValue() {
        return this.bean;
    }

    @Override
    public List<BeanPropertyDescriptor> getPropertyDescriptorList() {
        return this.propertyDescriptorList;
    }

    @Override
    public boolean isNullPropertyUnassigned() {
        return this.nullPropertyUnassigned;
    }

    private boolean isPropertyChanged(Object oldValue, Object newValue) {
        if (oldValue == null && this.isNullPropertyUnassigned()) {
            return true;
        }
        return !ObjectUtils.equals(oldValue, newValue);
    }
}

