/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.beans;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyListener;
import net.sinodawn.framework.beans.impl.BeanPropertyInterceptorImpl;
import net.sinodawn.framework.utils.ClassUtils;
import org.springframework.cglib.proxy.Enhancer;

public abstract class BeanPropertyHelper {
    private static final Map<Class<?>, List<BeanPropertyDescriptor>> TYPE_CACHE = new HashMap();
    private static final Map<String, BeanPropertyDescriptor> PROPERTY_CACHE = new HashMap<String, BeanPropertyDescriptor>();

    public static BeanPropertyDescriptor getBeanPropertyDescriptor(Class<?> type, String name) {
        Class<?> rawType = ClassUtils.getRawType(type);
        String key = rawType.getName() + ":" + name.toUpperCase();
        if (!PROPERTY_CACHE.containsKey(key)) {
            BeanPropertyDescriptor propertyDescriptor = null;
            List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(rawType);
            for (BeanPropertyDescriptor loopPropertyDescriptor : propertyDescriptorList) {
                if (!loopPropertyDescriptor.getName().equalsIgnoreCase(name)) continue;
                propertyDescriptor = loopPropertyDescriptor;
                break;
            }
            PROPERTY_CACHE.put(key, propertyDescriptor);
        }
        return PROPERTY_CACHE.get(key);
    }

    public static <T> T getPropertyListenerProxy(T bean, boolean nullPropertyUndefined) {
        BeanPropertyInterceptorImpl<T> interceptor = new BeanPropertyInterceptorImpl<T>(bean, nullPropertyUndefined);
        Object originalValue = interceptor.getOriginalValue();
        if (ClassUtils.isCglibProxyClass(originalValue.getClass())) {
            return originalValue;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(originalValue.getClass());
        enhancer.setInterfaces(new Class[]{BeanPropertyListener.class});
        enhancer.setCallback(interceptor);
        return (T)enhancer.create();
    }

    public static List<BeanPropertyDescriptor> getBeanPropertyDescriptorList(Class<?> type) {
        List<BeanPropertyDescriptor> propertyDescriptorList = TYPE_CACHE.get(type = ClassUtils.getRawType(type));
        if (propertyDescriptorList == null) {
            propertyDescriptorList = new ArrayList<BeanPropertyDescriptor>();
            for (Class<?> searchType = type; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
                Field[] var3 = searchType.getDeclaredFields();
                int var4 = var3.length;
                for (Field f : var3) {
                    if (Modifier.isStatic(f.getModifiers()) || !propertyDescriptorList.stream().noneMatch(p -> p.getName().equals(f.getName()))) continue;
                    propertyDescriptorList.add(BeanPropertyDescriptor.of(f));
                }
            }
            propertyDescriptorList = Collections.unmodifiableList(propertyDescriptorList);
            TYPE_CACHE.put(type, propertyDescriptorList);
        }
        return propertyDescriptorList;
    }
}

