/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.audit.event;

import net.sinodawn.framework.data.CaseInsensitiveLinkedMap;
import net.sinodawn.framework.utils.ConvertUtils;
import org.springframework.context.ApplicationEvent;

public class AuditLogNotificationEvent
extends ApplicationEvent {
    private static final long serialVersionUID = -1774025047600647449L;
    private final String id;
    private final String activity;
    private final String comment;
    private final String signature;
    private final String userId;
    private final CaseInsensitiveLinkedMap<Object> oldValueMap;
    private CaseInsensitiveLinkedMap<Object> newValueMap;

    public AuditLogNotificationEvent(String table, String activity, String comment, String signature, String userId, CaseInsensitiveLinkedMap<Object> oldValueMap, CaseInsensitiveLinkedMap<Object> newValueMap) {
        super((Object)table);
        this.activity = activity;
        this.comment = comment;
        this.signature = signature;
        this.userId = userId;
        this.oldValueMap = oldValueMap;
        this.newValueMap = newValueMap;
        this.id = ConvertUtils.convert(oldValueMap != null && !oldValueMap.isEmpty() ? oldValueMap.get("id") : newValueMap.get("id"), String.class);
    }

    public String getId() {
        return this.id;
    }

    public String getActivity() {
        return this.activity;
    }

    public String getComment() {
        return this.comment;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getUserId() {
        return this.userId;
    }

    public CaseInsensitiveLinkedMap<Object> getOldValueMap() {
        return this.oldValueMap;
    }

    public CaseInsensitiveLinkedMap<Object> getNewValueMap() {
        return this.newValueMap;
    }

    public void setNewValueMap(CaseInsensitiveLinkedMap<Object> newValueMap) {
        this.newValueMap = newValueMap;
    }
}

