/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.audit.aspect;

import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.audit.AuditLogHelper;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.SinoAopContext;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnBean(name={"auditLogListener"})
@Order(value=0x7FFFFFFF)
public class AuditLogAspect {
    public static final String REQUEST_HEADER_COMMENT_KEY = "auditTrailComment";
    public static final String REQUEST_HEADER_SIGNATURE_KEY = "auditSignature";
    public static final String REQUEST_HEADER_AUDIT_ACTIVITY_KEY = "auditActivity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(audit)")
    public Object auditService(ProceedingJoinPoint pjp, Audit audit) throws Throwable {
        Object var5;
        boolean init;
        boolean bl = init = SinoAopContext.getCache("AUDIT_KEY") == null;
        if (init) {
            SinoAopContext.putCache("AUDIT_KEY", "1");
            SinoAopContext.putCache("AUDIT_EVENT_KEY", new ArrayList());
        }
        try {
            HttpServletRequest request = ServletUtils.getCurrentRequest();
            if (request != null) {
                if (SinoAopContext.getCache("AUDIT_COMMENT_KEY") == null) {
                    if (StringUtils.isEmpty(request.getHeader(REQUEST_HEADER_COMMENT_KEY))) {
                        SinoAopContext.putCache("AUDIT_COMMENT_KEY", request.getHeader(REQUEST_HEADER_COMMENT_KEY));
                    } else {
                        SinoAopContext.putCache("AUDIT_COMMENT_KEY", URLDecoder.decode(request.getHeader(REQUEST_HEADER_COMMENT_KEY), "utf-8"));
                    }
                }
                if (SinoAopContext.getCache("AUDIT_SIGNATURE_KEY") == null) {
                    if (StringUtils.isEmpty(request.getHeader(REQUEST_HEADER_SIGNATURE_KEY))) {
                        SinoAopContext.putCache("AUDIT_SIGNATURE_KEY", request.getHeader(REQUEST_HEADER_SIGNATURE_KEY));
                    } else {
                        SinoAopContext.putCache("AUDIT_SIGNATURE_KEY", URLDecoder.decode(request.getHeader(REQUEST_HEADER_SIGNATURE_KEY), "utf-8"));
                    }
                }
            }
            if (SinoAopContext.getCache("AUDIT_ACTIVITY_KEY") == null) {
                if (request != null && !StringUtils.isEmpty(request.getHeader(REQUEST_HEADER_AUDIT_ACTIVITY_KEY))) {
                    SinoAopContext.putCache("AUDIT_ACTIVITY_KEY", URLDecoder.decode(request.getHeader(REQUEST_HEADER_AUDIT_ACTIVITY_KEY), "utf-8"));
                } else {
                    SinoAopContext.putCache("AUDIT_ACTIVITY_KEY", audit.value());
                }
            }
            var5 = pjp.proceed();
        }
        finally {
            if (init) {
                AuditLogHelper.flush();
                SinoAopContext.removeCache("AUDIT_KEY");
                SinoAopContext.removeCache("AUDIT_EVENT_KEY");
                SinoAopContext.removeCache("AUDIT_ACTIVITY_KEY");
            }
        }
        return var5;
    }
}

