/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.framework.at.aspect;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import net.sinodawn.framework.at.AuditTrailHelper;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordLineService;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordService;
import net.sinodawn.module.sys.metadata.bean.CoreParentTableInstanceDTO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Profile(value={"audit-trail"})
public class AuditTrailAspect {
    public static final String AT_PRIMARY_SERVICE_KEY = "primaryService";
    public static final String AT_PRIMARY_ID_KEY = "primaryId";
    public static final String AT_COMMENT_KEY = "auditTrailComment";
    private static final ThreadLocal<AuditTrailEntryData> ENTRY_DATA = new ThreadLocal();
    private static final ThreadLocal<Map<String, List<CoreAuditTrailRecordLineBean>>> RECORD_DATA = new ThreadLocal();
    @Autowired
    private CoreAuditTrailRecordService recordService;
    @Autowired
    private CoreAuditTrailRecordLineService recordLineService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(auditTrailEntry)")
    public Object auditTrailService(ProceedingJoinPoint pjp, AuditTrailEntry auditTrailEntry) throws Throwable {
        if (AuditTrailHelper.auditTrail() && GenericService.class.isAssignableFrom(ClassUtils.getRawType(pjp.getTarget().getClass()))) {
            Object var12;
            boolean init = false;
            try {
                if (ENTRY_DATA.get() == null) {
                    HttpServletRequest request = ServletUtils.getCurrentRequest();
                    AuditTrailEntryData entryData = new AuditTrailEntryData(auditTrailEntry);
                    if (request != null) {
                        String primaryService = request.getHeader(AT_PRIMARY_SERVICE_KEY);
                        if (StringUtils.isEmpty(primaryService)) {
                            entryData.setPrimaryTableName(((GenericService)pjp.getTarget()).getDao().getTable());
                        } else {
                            GenericService service = (GenericService)ApplicationContextHelper.getBean(primaryService);
                            entryData.setPrimaryTableName(service.getDao().getTable());
                        }
                        entryData.setPrimaryId(request.getHeader(AT_PRIMARY_ID_KEY));
                    }
                    ENTRY_DATA.set(entryData);
                    RECORD_DATA.set(new HashMap());
                    init = true;
                }
                Object retValue = pjp.proceed();
                if (init) {
                    this.insertAuditTrail();
                }
                var12 = retValue;
            }
            finally {
                if (init) {
                    RECORD_DATA.remove();
                    ENTRY_DATA.remove();
                }
            }
            return var12;
        }
        return pjp.proceed();
    }

    public static final AuditTrailEntryData getAuditTrailEntryData() {
        return ENTRY_DATA.get();
    }

    public static final <ID extends Serializable> String getAncientTargetId(String lineTable, ID lineId) {
        return AuditTrailAspect.getAncientTargetMap(lineTable, Arrays.asList(lineId)).values().iterator().next();
    }

    public static final <ID extends Serializable> Map<ID, String> getAncientTargetMap(String lineTable, List<ID> lineIdList) {
        HashMap<Serializable, CallSite> map = new HashMap<Serializable, CallSite>();
        AuditTrailEntryData entryData = Optional.of(AuditTrailAspect.getAuditTrailEntryData()).get();
        if (StringUtils.isEmpty(entryData.getPrimaryId())) {
            List<CoreParentTableInstanceDTO> instanceList = ApplicationContextHelper.getAncientTableInstanceList(lineTable, lineIdList);
            for (Serializable lineId : lineIdList) {
                CoreParentTableInstanceDTO instance = instanceList.stream().filter(i -> i.getSourceId().equals(ObjectUtils.toString(lineId))).findAny().get();
                map.put(lineId, (CallSite)((Object)(instance.getTable() + "$" + instance.getId())));
            }
            return map;
        }
        for (Serializable lineId : lineIdList) {
            map.put(lineId, (CallSite)((Object)(entryData.getPrimaryTableName() + "$" + entryData.getPrimaryId())));
        }
        return map;
    }

    public static final void addRecordLine(String targetId, CoreAuditTrailRecordLineBean recordLine) {
        Map<String, List<CoreAuditTrailRecordLineBean>> map = RECORD_DATA.get();
        List<CoreAuditTrailRecordLineBean> lineList = map.get(targetId);
        if (lineList == null) {
            lineList = new ArrayList<CoreAuditTrailRecordLineBean>();
        }
        lineList.add(recordLine);
        map.put(targetId, lineList);
    }

    public static final void addRecordLine(String targetId, List<CoreAuditTrailRecordLineBean> recordLineList) {
        Map<String, List<CoreAuditTrailRecordLineBean>> map = RECORD_DATA.get();
        List<CoreAuditTrailRecordLineBean> lineList = map.get(targetId);
        if (lineList == null) {
            lineList = new ArrayList<CoreAuditTrailRecordLineBean>();
        }
        lineList.addAll(recordLineList);
        map.put(targetId, lineList);
    }

    private void insertAuditTrail() {
        Map<String, List<CoreAuditTrailRecordLineBean>> map;
        AuditTrailEntryData entryData = ENTRY_DATA.get();
        if (entryData != null && (map = RECORD_DATA.get()) != null && !map.isEmpty()) {
            ArrayList insertRecordList = new ArrayList();
            ArrayList<CoreAuditTrailRecordLineBean> insertRecordLineList = new ArrayList<CoreAuditTrailRecordLineBean>();
            map.forEach((k, v) -> {
                CoreAuditTrailRecordBean record = new CoreAuditTrailRecordBean();
                record.setId(ApplicationContextHelper.getNextIdentity());
                AuditTrailEntry entry = entryData.getEntry();
                record.setAuditTrailType(entry.value().name());
                record.setAuditTrailName(StringUtils.isEmpty(entry.name()) ? entry.value().getName() : entry.name());
                record.setTargetId((String)k);
                HttpServletRequest request = ServletUtils.getCurrentRequest();
                if (request != null) {
                    if (StringUtils.isEmpty(request.getHeader(AT_COMMENT_KEY))) {
                        record.setComment(request.getHeader(AT_COMMENT_KEY));
                    } else {
                        try {
                            record.setComment(URLDecoder.decode(request.getHeader(AT_COMMENT_KEY), "utf-8"));
                        }
                        catch (UnsupportedEncodingException var9) {
                            throw new UnexpectedException(var9);
                        }
                    }
                }
                insertRecordList.add(record);
                v.forEach(l -> l.setRecordId(record.getId()));
                insertRecordLineList.addAll((Collection<CoreAuditTrailRecordLineBean>)v);
            });
            this.recordService.getDao().insert(insertRecordList);
            this.recordLineService.insert(insertRecordLineList);
        }
    }

    public static class AuditTrailEntryData {
        private AuditTrailEntry entry;
        private String primaryTableName;
        private String primaryId;

        public AuditTrailEntryData(AuditTrailEntry entry) {
            this.entry = entry;
        }

        public String getPrimaryId() {
            return this.primaryId;
        }

        public void setPrimaryId(String primaryId) {
            this.primaryId = primaryId;
        }

        public String getPrimaryTableName() {
            return this.primaryTableName;
        }

        public void setPrimaryTableName(String primaryTableName) {
            this.primaryTableName = primaryTableName;
        }

        public AuditTrailEntry getEntry() {
            return this.entry;
        }
    }
}

