/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.boot.security;

import java.util.Optional;
import java.util.function.Function;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.filter.ContextServletRequestFilter;
import net.sinodawn.framework.security.filter.RefreshFilterSecurityInterceptor;
import net.sinodawn.framework.security.service.DefaultTokenBasedRememberMeServices;
import net.sinodawn.framework.security.service.DefaultUserDetailsService;
import net.sinodawn.framework.security.support.AjaxAuthenticationFailureHandler;
import net.sinodawn.framework.security.support.AjaxAuthenticationSuccessHandler;
import net.sinodawn.framework.security.support.DefaultDaoAuthenticationProvider;
import net.sinodawn.framework.security.support.Http401UnauthorizedEntryPoint;
import net.sinodawn.framework.spring.filter.SinoFilterConfig;
import net.sinodawn.framework.spring.filter.SinoFilterRegistry;
import net.sinodawn.framework.utils.EncryptUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;

@Configuration
@EnableWebSecurity
public class SinoSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    public static final String CUSTOM_SECURITY_CONFIGURE_FUNCTION_NAME = "customSecurityConfigure";
    public static final String LOGIN_ORG_ID_KEY = "orgId";
    public static final String LOGIN_ROLE_ID_KEY = "roleId";
    @Autowired
    Environment env;
    @Lazy
    @Autowired
    UserDetailsService userDetailsService;
    @Lazy
    @Autowired
    RememberMeServices rememberMeServices;
    @Lazy
    @Autowired
    PasswordEncoder passwordEncoder;
    @Lazy
    @Autowired
    AuthenticationProvider authenticationProvider;

    @Bean
    public UserDetailsService userDetailsService() {
        return new DefaultUserDetailsService();
    }

    @Bean
    public AuthenticationProvider authenticationProvider() {
        DefaultDaoAuthenticationProvider authenticationProvider = new DefaultDaoAuthenticationProvider();
        authenticationProvider.setUserDetailsService(this.userDetailsService);
        authenticationProvider.setPasswordEncoder(this.passwordEncoder);
        return authenticationProvider;
    }

    @Bean
    public RememberMeServices rememberMeServices() {
        return this.defaultTokenBasedRememberMeServices();
    }

    @Bean
    public DefaultTokenBasedRememberMeServices defaultTokenBasedRememberMeServices() {
        DefaultTokenBasedRememberMeServices rememberMeServices = new DefaultTokenBasedRememberMeServices();
        Optional.ofNullable(this.env.getProperty("sino.security.token-validity-seconds")).or(() -> Optional.of("36000")).ifPresent(seconds -> rememberMeServices.setTokenValiditySeconds(Integer.parseInt(seconds)));
        return rememberMeServices;
    }

    private void init(HttpSecurity http) throws Exception {
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)ApplicationContextHelper.getBean(Http401UnauthorizedEntryPoint.class));
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.rememberMe().rememberMeServices(this.rememberMeServices).key("sino-remember-me");
        ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginPage("/").loginProcessingUrl("/core/module/sys/login")).failureHandler((AuthenticationFailureHandler)ApplicationContextHelper.getBean(AjaxAuthenticationFailureHandler.class))).successHandler((AuthenticationSuccessHandler)ApplicationContextHelper.getBean(AjaxAuthenticationSuccessHandler.class))).usernameParameter("id").passwordParameter("pwd");
        http.logout().logoutSuccessUrl("/").logoutUrl("/core/module/sys/logout").addLogoutHandler((LogoutHandler)ApplicationContextHelper.getBean(DefaultTokenBasedRememberMeServices.class)).logoutSuccessHandler(ApplicationContextHelper.getBean(LogoutSuccessHandler.class)).deleteCookies(new String[]{"security#rememberme", "JSESSIONID"});
    }

    @Bean
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        return new PasswordEncoder(){

            public String encode(CharSequence rawPassword) {
                return EncryptUtils.MD5Encrypt((String)rawPassword);
            }

            public boolean matches(CharSequence rawPassword, String encodedPassword) {
                return rawPassword != null && this.encode(rawPassword).equals(encodedPassword);
            }
        };
    }

    @Bean
    public HttpFirewall allowUrlEncodedSlashHttpFirewall() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowUrlEncodedPercent(true);
        firewall.setAllowUrlEncodedSlash(true);
        firewall.setAllowSemicolon(true);
        return firewall;
    }

    public void configure(WebSecurity web) throws Exception {
        web.httpFirewall(this.allowUrlEncodedSlashHttpFirewall());
    }

    protected void configure(HttpSecurity http) throws Exception {
        this.init(http);
        if (this.getApplicationContext().containsBean(CUSTOM_SECURITY_CONFIGURE_FUNCTION_NAME)) {
            Function function = (Function)this.getApplicationContext().getBean(CUSTOM_SECURITY_CONFIGURE_FUNCTION_NAME);
            function.apply(http);
        }
        http.csrf().disable();
        if (((Boolean)this.env.getProperty("sino.security.headers.xss", Boolean.class)).booleanValue()) {
            http.headers().frameOptions().sameOrigin().addHeaderWriter((HeaderWriter)new XXssProtectionHeaderWriter());
        } else {
            http.headers().frameOptions().disable().addHeaderWriter((HeaderWriter)new XXssProtectionHeaderWriter());
        }
        SinoFilterRegistry.INSTANCE.getConfigList().forEach(c -> {
            if (SinoFilterConfig.FilterPos.AFTER.equals((Object)c.getFilterPos())) {
                http.addFilterAfter(c.getFilter(), c.getFilterClass());
            } else if (SinoFilterConfig.FilterPos.BEFORE.equals((Object)c.getFilterPos())) {
                http.addFilterBefore(c.getFilter(), c.getFilterClass());
            } else if (SinoFilterConfig.FilterPos.AT.equals((Object)c.getFilterPos())) {
                http.addFilterAt(c.getFilter(), c.getFilterClass());
            }
        });
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/**/*.md", "/**/*.sql", "/**/*.jar", "/**/*.jsp", "/**/*.asp", "/**/*.aspx", "/**/*.php", "/**/*.py"})).denyAll().antMatchers(new String[]{"/secure/core/module/mdm/user-permissions/login-org/queries/post-selectable", "/secure/core/module/mdm/user-permissions/login-role/queries/post-selectable", "/*", "/static/**", "/open/**", "/files/open/**", "/core/module/sys/login"})).permitAll().antMatchers(new String[]{"/module/index/workspaces/**", "/core/module/sys/logins/account", "/core/module/sys/logout", "/core/module/item/files", "/secure/**"})).authenticated();
    }

    static {
        SinoFilterRegistry.INSTANCE.registerBefore(new ContextServletRequestFilter(), ChannelProcessingFilter.class);
        SinoFilterRegistry.INSTANCE.registerAfter(new RefreshFilterSecurityInterceptor(), FilterSecurityInterceptor.class);
    }
}

