/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.boot;

import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import net.sinodawn.framework.database.dialect.Dialect;
import net.sinodawn.framework.database.dialect.MysqlDialect;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableTransactionManagement
@EnableAsync
@EnableScheduling
@EnableCaching
public class SinoApplicationConfiguration
extends ApplicationObjectSupport
implements SchedulingConfigurer {
    @Autowired
    Environment env;
    @Autowired
    DataSource dataSource;

    @Bean
    @Primary
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return new RestTemplate();
    }

    @Bean
    public ThreadPoolExecutor threadPoolExecutor() {
        return new ThreadPoolExecutor(4, 8, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(5));
    }

    @Bean
    public DataSource dataSource() {
        HikariDataSource var = new HikariDataSource();
        var.setJdbcUrl(this.env.getProperty("spring.datasource.url"));
        var.setUsername(this.env.getProperty("spring.datasource.username"));
        var.setPassword(this.env.getProperty("spring.datasource.password"));
        return var;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory() {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(this.dataSource);
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.setLogImpl(StdOutImpl.class);
        sqlSessionFactoryBean.setConfiguration(configuration);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            sqlSessionFactoryBean.setMapperLocations(resolver.getResources("classpath*:/**/*mysql-mapper.xml"));
            return sqlSessionFactoryBean.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Bean
    RestTemplateBuilder restTemplateBuilder() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]);
    }

    @Bean
    RedisConnectionFactory redisConnectionFactory() {
        return new LettuceConnectionFactory();
    }

    @Bean
    RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)StringRedisSerializer.UTF_8);
        redisTemplate.setHashKeySerializer((RedisSerializer)StringRedisSerializer.UTF_8);
        return redisTemplate;
    }

    @Bean
    public Logger logger() {
        return LoggerFactory.getLogger((String)"LOG");
    }

    @Bean
    public Dialect dialect() {
        return new MysqlDialect();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
    }
}

