/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.service.impl;

import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.MaskImplementationException;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.dao.CoreRoleUserDao;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Repository
public class CoreRoleUserServiceImpl implements CoreRoleUserService {
   @Autowired
   private CoreRoleUserDao roleUserDao;
   @Lazy
   @Autowired
   private CoreRoleService coreRoleService;
   @Lazy
   @Autowired
   private CoreUserService coreUserService;
   @Lazy
   @Autowired
   private CoreRoleUserService proxyInstance;

   public CoreRoleUserDao getDao() {
      return this.roleUserDao;
   }

   @Transactional
   @CacheEvict(
      value = {"T_CORE_ROLE_USER.SOURCE_USER_ID"},
      key = "#userId"
   )
   public Long insertByUserId(String userId, List<Long> roleIdList) {
      if (roleIdList.isEmpty()) {
         return null;
      } else {
         List<CoreRoleUserBean> insertRoleUserList = (List)roleIdList.stream().map((r) -> {
            CoreRoleUserBean roleUser = new CoreRoleUserBean();
            roleUser.setId(ApplicationContextHelper.getNextIdentity());
            roleUser.setRoleId(r);
            roleUser.setUserId(userId);
            return roleUser;
         }).collect(Collectors.toList());
         this.getDao().insert(insertRoleUserList);
         return ((CoreRoleUserBean)insertRoleUserList.get(0)).getId();
      }
   }

   @Transactional
   @CacheEvict(
      value = {"T_CORE_ROLE_USER.SOURCE_USER_ID"},
      key = "#userId"
   )
   public void deleteByUserId(String userId, List<Long> roleIdList) {
      if (!roleIdList.isEmpty()) {
         CoreRoleUserBean filter = new CoreRoleUserBean();
         filter.setUserId(userId);
         List<CoreRoleUserBean> roleUserList = this.getDao().selectList(filter, new Order[0]);
         this.getDao().deleteByIdList((List)roleUserList.stream().filter((r) -> {
            return roleIdList.contains(r.getRoleId());
         }).map(CoreRoleUserBean::getId).collect(Collectors.toList()));
      }

   }

   @Transactional
   @CacheEvict(
      value = {"T_CORE_ROLE_USER.SOURCE_USER_ID"},
      key = "#userId"
   )
   public void deleteByUserId(String userId) {
      CoreRoleUserBean filter = new CoreRoleUserBean();
      filter.setUserId(userId);
      this.getDao().deleteBy(filter, new String[]{"USERID"});
   }

   @Transactional
   public void deleteByRoleId(Long roleId) {
      CoreRoleUserBean filter = new CoreRoleUserBean();
      filter.setRoleId(roleId);
      List<CoreRoleUserBean> roleUserList = this.getDao().selectList(filter, new Order[0]);
      if (!roleUserList.isEmpty()) {
         roleUserList.forEach((r) -> {
            this.proxyInstance.deleteByUserId(r.getUserId(), Arrays.asList(r.getRoleId()));
         });
      }

   }

   @Cacheable(
      value = {"T_CORE_ROLE_USER.SOURCE_USER_ID"},
      key = "#userId"
   )
   public List<CoreRoleUserBean> selectByUserId(String userId) {
      CoreRoleUserBean filter = new CoreRoleUserBean();
      filter.setUserId(userId);
      return this.getDao().selectListByOneColumnValue(userId, "USERID", new Order[0]);
   }

   public List<String> selectUserList(Long roleId) {
      CoreRoleUserBean filter = new CoreRoleUserBean();
      filter.setRoleId(roleId);
      return this.getDao().selectColumnList(filter, "USERID", String.class, new Order[0]);
   }

   public Page<CoreRoleUserBean> selectPaginationByRole(Long roleId, RestJsonWrapperBean wrapper) {
      MapperParameter parameter = wrapper.extractMapFilter();
      parameter.setFilter(SearchFilter.instance().match((String)"ROLEID", roleId).filter(MatchPattern.EQ));
      PageRowBounds rowBounds = wrapper.extractPageRowBounds();
      return this.selectPagination(parameter, rowBounds);
   }

   @Transactional
   @AuditTrailEntry(AuditTrailType.INSERT)
   @Audit("AUDIT.INSERT")
   public Long insert(RestJsonWrapperBean wrapper) {
      List<CoreRoleUserBean> roleUserList = wrapper.parse(CoreRoleUserBean.class);
      Map<String, List<Long>> mapList = (Map)roleUserList.stream().collect(Collectors.groupingBy(CoreRoleUserBean::getUserId, Collectors.mapping(CoreRoleUserBean::getRoleId, Collectors.toList())));
      mapList.forEach((k, v) -> {
         this.proxyInstance.insertByUserId(k, v);
      });
      return null;
   }

   @Transactional
   @AuditTrailEntry(AuditTrailType.UPDATE)
   @Audit("AUDIT.SAVE")
   @CacheEvict(
      value = {"T_CORE_ROLE_USER.SOURCE_USER_ID"},
      key = "#userId"
   )
   public void setDefault(String userId, RestJsonWrapperBean wrapper) {
      List<CoreRoleUserBean> updateCoreRoleUserList = new ArrayList();
      List<CoreRoleUserBean> coreRoleUserList = this.selectListByFilter(SearchFilter.instance().match((String)"USERID", userId).filter(MatchPattern.EQ).match((String)"DEFAULTFLAG", "1").filter(MatchPattern.EQ), new Order[0]);
      CoreRoleUserBean defaultRoleUser;
      if (!coreRoleUserList.isEmpty()) {
         defaultRoleUser = (CoreRoleUserBean)coreRoleUserList.get(0);
         defaultRoleUser.setDefaultFlag("0");
         updateCoreRoleUserList.add(defaultRoleUser);
      }

      defaultRoleUser = (CoreRoleUserBean)wrapper.parseUnique(CoreRoleUserBean.class);
      defaultRoleUser.setDefaultFlag("1");
      updateCoreRoleUserList.add(defaultRoleUser);
      this.getDao().update(updateCoreRoleUserList, new String[]{"DEFAULTFLAG"});
   }

//   public List<MatrixHeaderBean> selectMatrixHeaderList() {
//      List<CoreRoleBean> roleList = this.coreRoleService.selectAll();
//      return (List)roleList.stream().map((r) -> {
//         MatrixHeaderBean header = MatrixHeaderBean.getRotateInstance(this.coreRoleService.getDao().getTable(), r.getId(), "ROLENAME", r.getRoleName());
//         header.setJavaType(String.class.getSimpleName());
//         header.setType("simpleCheckbox");
//         header.setEditor(true);
//         header.setReadonly(false);
//         return header;
//      }).collect(Collectors.toList());
//   }
//
//   public Page<MatrixRowMap> selectMatrixRowPagination(RestJsonWrapperBean wrapper) {
//      MapperParameter parameter = wrapper.extractMapFilter();
//      Page<CoreUserBean> userPagination = this.coreUserService.selectPagination(MatrixHelper.getStandardMapperParameter(parameter));
//      if (userPagination.getRows().isEmpty()) {
//         return new Pagination();
//      } else {
//         List<String> userIdList = (List)userPagination.getRows().stream().map(CoreUserBean::getId).collect(Collectors.toList());
//         List<CoreRoleUserBean> roleUserList = this.getDao().selectListByOneColumnValues(userIdList, "userId", new Order[0]);
//         Map<String, List<CoreRoleUserBean>> map = (Map)roleUserList.stream().collect(Collectors.groupingBy(CoreRoleUserBean::getUserId, Collectors.toList()));
//         List<MatrixRowMap> rowList = new ArrayList();
//
//         List filteredRoleList;
//         MatrixRowMap row;
//         for(Iterator var8 = userPagination.getRows().iterator(); var8.hasNext(); rowList.add(row)) {
//            CoreUserBean user = (CoreUserBean)var8.next();
//            filteredRoleList = (List)map.get(user.getId());
//            row = new MatrixRowMap();
//            row.putRowId(this.coreUserService.getDao().getTable(), user.getId());
//            row.putItem(user);
//            if (filteredRoleList != null && !filteredRoleList.isEmpty()) {
//               filteredRoleList.forEach((ru) -> {
//                  row.putRotateValue(this.coreRoleService.getDao().getTable(), ru.getRoleId(), "ROLENAME", "1");
//               });
//               row.setPredicate((t) -> {
//                  return MatchPattern.EQ.name().equals(t.getMatchPattern()) ? t.getMap().entrySet().stream().allMatch((e) -> {
//                     Object v = CollectionUtils.getValueIgnorecase(row, (String)e.getKey());
//                     if (StringUtils.startsWith((String)e.getKey(), this.coreRoleService.getDao().getTable()) && "0".equals(e.getValue())) {
//                        return v == null || "0".equals(v);
//                     } else {
//                        return ObjectUtils.equals(v, e.getValue());
//                     }
//                  }) : t.match(row);
//               });
//            }
//         }
//
//         List<MatrixRowMap> filteredRowList = MatrixHelper.getFilteredRowList(parameter, rowList);
//         MatrixHelper.sortRowList(parameter, filteredRowList);
//         Page<MatrixRowMap> matrixRowPagination = new Pagination(filteredRowList);
//         matrixRowPagination.setColumnTypeMap(userPagination.getColumnTypeMap());
//         filteredRoleList = this.selectMatrixHeaderList();
//         filteredRoleList.forEach((m) -> {
//            String var10000 = (String)matrixRowPagination.getColumnTypeMap().put(m.getField(), m.getJavaType().toLowerCase());
//         });
//         return matrixRowPagination;
//      }
//   }

   @Transactional
   public void save(List<Map<String, Object>> mapList) {
      mapList.forEach((m) -> {
         String userId = (String)CollectionUtils.getValueIgnorecase(m, "id");
         String key = (String)m.keySet().stream().filter((k) -> {
            return k.startsWith("T_CORE_ROLE$ROLENAME$");
         }).findAny().get();
         Long roleId = NumberUtils.parseLong(StringUtils.removeStart(key, "T_CORE_ROLE$ROLENAME$"));
         CoreRoleUserBean filter = new CoreRoleUserBean();
         filter.setUserId(userId);
         filter.setRoleId(roleId);
         CoreRoleUserBean roleUser = (CoreRoleUserBean)this.getDao().selectFirstIfPresent(filter, new Order[0]);
         if ("1".equals(m.get(key))) {
            if (roleUser == null) {
               this.proxyInstance.insertByUserId(userId, Arrays.asList(roleId));
            }
         } else if (roleUser != null) {
            this.proxyInstance.deleteByUserId(userId, Arrays.asList(roleId));
         }

      });
   }

   public void delete(Long id) {
      throw new MaskImplementationException();
   }

   public void delete(RestJsonWrapperBean wrapper) {
      throw new MaskImplementationException();
   }

   public void update(CoreRoleUserBean proxy) {
      throw new MaskImplementationException();
   }

   public void updateIfChanged(List<CoreRoleUserBean> itemList) {
      throw new MaskImplementationException();
   }

   public void updateIfChanged(CoreRoleUserBean item) {
      throw new MaskImplementationException();
   }

   public void save(Long id, RestJsonWrapperBean wrapper) {
      throw new MaskImplementationException();
   }
}
