/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.service.impl;

import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.module.sys.role.bean.CoreRolePermissionTypeBean;
import net.sinodawn.module.sys.role.dao.CoreRolePermissionTypeDao;
import net.sinodawn.module.sys.role.service.CoreRolePermissionTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class CoreRolePermissionTypeServiceImpl implements CoreRolePermissionTypeService {
   @Autowired
   private CoreRolePermissionTypeDao permissionTypeDao;

   public CoreRolePermissionTypeDao getDao() {
      return this.permissionTypeDao;
   }

   public List<CoreRolePermissionTypeBean> selectListByPermissionType(String permissionType) {
      CoreRolePermissionTypeBean condition = new CoreRolePermissionTypeBean();
      condition.setPermissionType(permissionType);
      return this.getDao().selectList(condition, new Order[0]);
   }
}
