/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.service.impl;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.MaskImplementationException;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.bean.CoreRolePermissionBean;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.dao.CoreRolePermissionDao;
import net.sinodawn.module.sys.role.service.CoreRolePermissionService;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Repository
public class CoreRolePermissionServiceImpl implements CoreRolePermissionService {
   @Autowired
   private CoreRolePermissionDao permissionDao;
   @Lazy
   @Autowired
   private CoreRoleUserService roleUserService;
   @Lazy
   @Autowired
   private CoreRoleService roleService;
   @Lazy
   @Autowired
   private CoreRolePermissionService proxyInstance;

   public CoreRolePermissionDao getDao() {
      return this.permissionDao;
   }

   @Transactional
   public Long insert(RestJsonWrapperBean wrapper) {
      List<CoreRolePermissionBean> rolePermissionList = wrapper.parse(CoreRolePermissionBean.class);
      if (!rolePermissionList.isEmpty()) {
         Map<Long, List<CoreRolePermissionBean>> map = (Map)rolePermissionList.stream().collect(Collectors.groupingBy(CoreRolePermissionBean::getRoleId));
         map.forEach((r, m) -> {
            Map<String, List<String>> targetMap = (Map)m.stream().collect(Collectors.toMap(CoreRolePermissionBean::getPermissionTypeId, (x) -> {
               return new ArrayList(Collections.singletonList(x.getTargetId()));
            }, (o1List, o2List) -> {
               o1List.addAll(o2List);
               return o1List;
            }));
            targetMap.forEach((p, t) -> {
               this.proxyInstance.insert(r, p, t);
            });
         });
      }

      return null;
   }

   @Transactional
   @CacheEvict(
      value = {"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"},
      key = "'' + #roleId"
   )
   public void insert(Long roleId, String permissionTypeId, List<String> targetIdList) {
      Set<String> permissionIdSet = (Set)this.proxyInstance.selectListByRole(roleId).stream().filter((p) -> {
         return permissionTypeId.equals(p.getPermissionTypeId());
      }).map(CoreRolePermissionBean::getTargetId).collect(Collectors.toSet());
      List<CoreRolePermissionBean> insertPermissionList = (List)targetIdList.stream().filter((t) -> {
         return !permissionIdSet.contains(t);
      }).map((t) -> {
         CoreRolePermissionBean permission = new CoreRolePermissionBean();
         permission.setId(ApplicationContextHelper.getNextIdentity());
         permission.setRoleId(roleId);
         permission.setPermissionTypeId(permissionTypeId);
         permission.setTargetId(t);
         return permission;
      }).collect(Collectors.toList());
      this.getDao().insert(insertPermissionList);
   }

   @Transactional
   public void delete(RestJsonWrapperBean wrapper) {
      List<Long> idList = wrapper.parseId(Long.class);
      if (!idList.isEmpty()) {
         List<CoreRolePermissionBean> rolePermissionList = this.getDao().selectListByIds(idList, new Order[0]);
         Map<Long, List<CoreRolePermissionBean>> map = (Map)rolePermissionList.stream().collect(Collectors.groupingBy(CoreRolePermissionBean::getRoleId));
         map.forEach((r, m) -> {
            Map<String, List<String>> targetMap = (Map)m.stream().collect(Collectors.toMap(CoreRolePermissionBean::getPermissionTypeId, (x) -> {
               return new ArrayList(Collections.singletonList(x.getTargetId()));
            }, (o1List, o2List) -> {
               o1List.addAll(o2List);
               return o1List;
            }));
            targetMap.forEach((p, t) -> {
               this.proxyInstance.delete(r, p, t);
            });
         });
      }
   }

   @Transactional
   @CacheEvict(
      value = {"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"},
      key = "'' + #roleId"
   )
   public void delete(Long roleId, String permissionTypeId, List<String> targetIdList) {
      List<CoreRolePermissionBean> deletePermissionList = (List)targetIdList.stream().map((t) -> {
         CoreRolePermissionBean permission = new CoreRolePermissionBean();
         permission.setRoleId(roleId);
         permission.setPermissionTypeId(permissionTypeId);
         permission.setTargetId(t);
         return permission;
      }).collect(Collectors.toList());
      this.getDao().deleteBy(deletePermissionList, new String[]{"ROLEID", "TARGETID", "PERMISSIONTYPEID"});
   }

   @Transactional
   @CacheEvict(
      value = {"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"},
      key = "'' + #roleId"
   )
   public void deleteByRoleId(Long roleId) {
      CoreRolePermissionBean filter = new CoreRolePermissionBean();
      filter.setRoleId(roleId);
      this.getDao().deleteBy(filter, new String[]{"ROLEID"});
   }

   @Cacheable(
      value = {"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"},
      key = "'' + #roleId"
   )
   public List<CoreRolePermissionBean> selectListByRole(Long roleId) {
      CoreRolePermissionBean filter = new CoreRolePermissionBean();
      filter.setRoleId(roleId);
      return this.getDao().selectList(filter, new Order[0]);
   }

   public List<CoreRolePermissionBean> selectActiveUserPermissionList(String userId, String permissionType) {
      List<CoreRoleUserBean> roleUserList = this.roleUserService.selectByUserId(userId);
      List<CoreRolePermissionBean> rolePermissionList = new ArrayList();
      Iterator var5 = roleUserList.iterator();

      while(var5.hasNext()) {
         CoreRoleUserBean roleUser = (CoreRoleUserBean)var5.next();
         CoreRoleBean role = (CoreRoleBean)this.roleService.selectByIdIfPresent(roleUser.getRoleId());
         if (role != null && "0".equals(role.getLastSuspendedFlag())) {
            List<CoreRolePermissionBean> allPermissionList = this.proxyInstance.selectListByRole(role.getId());
            rolePermissionList.addAll((Collection)allPermissionList.stream().filter((p) -> {
               return permissionType.equals(p.getPermissionTypeId());
            }).collect(Collectors.toList()));
         }
      }

      return rolePermissionList;
   }

   public String selectPermissionTypeAdmin(String permisionTypeId) {
      List<CoreRoleUserBean> roleUserList = this.roleUserService.selectByUserId(LocalContextHelper.getLoginUserId());
      Iterator var3 = roleUserList.iterator();

      while(var3.hasNext()) {
         CoreRoleUserBean roleUser = (CoreRoleUserBean)var3.next();
         CoreRoleBean role = (CoreRoleBean)this.roleService.selectByIdIfPresent(roleUser.getRoleId());
         if (role != null) {
            List<CoreRolePermissionBean> allPermissionList = this.proxyInstance.selectListByRole(role.getId());
            if (allPermissionList.stream().anyMatch((p) -> {
               return p.getPermissionTypeId().equals(permisionTypeId) && "0".equals(p.getTargetId());
            })) {
               return "1";
            }
         }
      }

      return "0";
   }

   public void delete(Long id) {
      throw new MaskImplementationException();
   }

   public void update(CoreRolePermissionBean proxy) {
      throw new MaskImplementationException();
   }

   public void updateIfChanged(List<CoreRolePermissionBean> itemList) {
      throw new MaskImplementationException();
   }

   public void updateIfChanged(CoreRolePermissionBean item) {
      throw new MaskImplementationException();
   }

   public void save(Long id, RestJsonWrapperBean wrapper) {
      throw new MaskImplementationException();
   }
}
